<?php
session_start();

$realm = 'Restricted area';

//user => password
$users = array('avaco' => 'dev');


if (empty($_SERVER['PHP_AUTH_DIGEST'])) {
    header('HTTP/1.1 401 Unauthorized');
    header('WWW-Authenticate: Digest realm="' . $realm .
        '",qop="auth",nonce="' . uniqid() . '",opaque="' . md5($realm) . '"');

    die('Smart Choose');
}


// analyze the PHP_AUTH_DIGEST variable
if (!($data = http_digest_parse($_SERVER['PHP_AUTH_DIGEST'])) ||
    !isset($users[$data['username']]))
    die('Wrong Credentials!');


// generate the valid response
$A1 = md5($data['username'] . ':' . $realm . ':' . $users[$data['username']]);
$A2 = md5($_SERVER['REQUEST_METHOD'] . ':' . $data['uri']);
$valid_response = md5($A1 . ':' . $data['nonce'] . ':' . $data['nc'] . ':' . $data['cnonce'] . ':' . $data['qop'] . ':' . $A2);

if ($data['response'] != $valid_response)
    die('Wrong Credentials!');


// function to parse the http auth header
function http_digest_parse($txt)
{
    // protect against missing data
    $needed_parts = array('nonce' => 1, 'nc' => 1, 'cnonce' => 1, 'qop' => 1, 'username' => 1, 'uri' => 1, 'response' => 1);
    $data = array();
    $keys = implode('|', array_keys($needed_parts));

    preg_match_all('@(' . $keys . ')=(?:([\'"])([^\2]+?)\2|([^\s,]+))@', $txt, $matches, PREG_SET_ORDER);

    foreach ($matches as $m) {
        $data[$m[1]] = $m[3] ? $m[3] : $m[4];
        unset($needed_parts[$m[1]]);
    }

    return $needed_parts ? false : $data;
}


function sanitize_output($buffer) {
    
    require_once('min/lib/Minify/HTML.php');
    require_once('min/lib/Minify/CSS.php');
    require_once('min/lib/JSMin.php');
    $buffer = Minify_HTML::minify($buffer, array(
        'cssMinifier' => array('Minify_CSS', 'minify'),
        'jsMinifier' => array('JSMin', 'minify')
    ));
    
    $find=array('href="/sr/"','href="https://www.avaco.gw.in.rs/sr/"',"Ar ","http://www.avaco.gw.in.rs");
    $replace=array('href="/"','href="https://www.avaco.gw.in.rs"',"AR ","https://www.avaco.gw.in.rs");
    
    return str_replace($find,$replace,$buffer);
}
ob_start('sanitize_output');


?>
<?php
include 'class/classes.php';
$url_params = $_SERVER["REQUEST_URI"];

if($base != "/")
    $url_params = explode("/",$url_params);

//Load LanguageXML
    $xml= simplexml_load_file("languages/arrent.xml") or die("XML not found");


$lang = $url_params[1];
$page = $url_params[2];


$pages=array("unser-fahrzeug","rent-a-car-nis","rent-a-car-kraljevo","login","home","vozni-park","page","lokacije","blog-list","blog","our-vehicle","locations","car-rental","iznajmljivanje-vozila");

 $actual_link = "https://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
if ($actual_link=='https://www.avaco.gw.in.rs/index.php' || $actual_link=='https://www.avaco.gw.in.rs/index.html' || $actual_link=='https://www.avaco.gw.in.rs/index.html/' || $actual_link=='https://www.avaco.gw.in.rs/sr/index.html/' || $actual_link=='https://www.avaco.gw.in.rs/sr/index.php/') {
    $actual_link= "https://www.avaco.gw.in.rs";
    header("HTTP/1.1 301 Moved Permanently"); 
        header("Location: $actual_link"); 
        exit();
}

if($actual_link=="https://www.avaco.gw.in.rs/sr/page/iznajmljivanje-kampera/"){
	echo "Ovde";
	$actual_link= "https://www.avaco.gw.in.rs";
    header("HTTP/1.1 301 Moved Permanently"); 
        header("Location: $actual_link"); 
        exit();
}

$homeredirect=array("https://www.avaco.gw.in.rs/kombi-prevoz-subotica-bec.html/blog//","https://www.avaco.gw.in.rs/kombi-prevoz-novi-sad-bec.html/blog//","https://www.avaco.gw.in.rs/automobili-cena/blog//","https://www.avaco.gw.in.rs/uslovi-informacije/blog//","http://www.avaco.gw.in.rs/terms-conditions__trashed/blog//","https://www.avaco.gw.in.rs/hvala-na-pozivu.html/blog//","https://www.avaco.gw.in.rs/wp-json/blog//","http://www.avaco.gw.in.rs/kontakt.html/blog//","http://www.avaco.gw.in.rs/wp-includes/blog//","https://www.avaco.gw.in.rs/wp-content/blog//","https://www.avaco.gw.in.rs/kombi-prevoz/blog//","http://www.avaco.gw.in.rs/xmlrpc.php/blog//","https://www.avaco.gw.in.rs/search/blog//","https://www.avaco.gw.in.rs/sr/page/rent-a-car-topola/","https://www.avaco.gw.in.rs/sr/page/rent-a-car-mladenovac/","https://www.avaco.gw.in.rs/sr/page/iznajmljivanje-kampera/","https://www.avaco.gw.in.rs/sr/page/rent-a-car-cacak/","https://www.avaco.gw.in.rs/sr/rent-a-car-kraljevo/","https://www.avaco.gw.in.rs/sr/page/rent-a-car-krusevac/","https://www.avaco.gw.in.rs/sr/page/rent-a-car-novi-sad/","https://www.avaco.gw.in.rs/sr/page/rent-a-car-vrnjacka-banja/","https://www.avaco.gw.in.rs/sr/page/rent-a-car-bez-depozita/","https://www.avaco.gw.in.rs/sr/page/rent-a-car-lazarevac/");
if (in_array($actual_link,$homeredirect)) {
    $actual_link= "https://www.avaco.gw.in.rs";
    header("HTTP/1.1 301 Moved Permanently"); 
        header("Location: $actual_link"); 
        exit();
}

if($actual_link=="https://www.avaco.gw.in.rs/en/car-rental/skoda-rapid-1-2-tsi-benzin/8/" || $actual_link=="https://www.avaco.gw.in.rs/en/car-rental/renault-megane-1-5dci-karavan-1500cc/10/" || $actual_link=="https://www.avaco.gw.in.rs/sr/iznajmljivanje-vozila/renault-megane-1-5dci-karavan-1500cc/10/" || $actual_link=="https://www.avaco.gw.in.rs/sr/iznajmljivanje-vozila/skoda-rapid-1-2-tsi-benzin/8/" || $actual_link=="https://www.avaco.gw.in.rs/en/car-rental/skoda-fabia-1-2-1200cc-benzin/4/"){
    $actual_link= "https://www.avaco.gw.in.rs/en/our-vehicle/";
    header("HTTP/1.1 301 Moved Permanently"); 
        header("Location: $actual_link"); 
        exit();
}

if($actual_link=="http://www.avaco.gw.in.rs/sr/iznajmljivanje-vozila/skoda-fabia-1-2-1200cc-benzin/4/"){
    $actual_link= "http://www.avaco.gw.in.rs/sr/vozni-park/";
    header("HTTP/1.1 301 Moved Permanently"); 
        header("Location: $actual_link"); 
        exit();
}

//redirect zombie queries
if($page!=""){
    if (!in_array($page, $pages)) {
         header('HTTP/1.1 404 Not Found');
         include '404.php';
         exit();
    }
}

if($url_params[3]=="404"){
    header('HTTP/1.1 404 Not Found');
}
    
    
   
    
if (strpos($actual_link, 'mm_') !== false) {
    $actual_link= "http://www.avaco.gw.in.rs";
    header("Location: $actual_link", true, 301);
}

if ($actual_link=='http://www.avaco.gw.in.rs/sr/') {
    $actual_link= "http://www.avaco.gw.in.rs";
    header("Location: $actual_link", true, 301);
}

if ((strpos($actual_link, 'index.php') !== false)) {
    $actual_link= "http://www.avaco.gw.in.rs/".$lang."/";
    header("Location: $actual_link", true, 301);
}
    
    if($page=="home"){
        header("Location: http://www.avaco.gw.in.rs/".$lang."/", true, 301);
    }

        $db = new DBConfig();
        $db -> config();
        $db -> conn();
        $db2 = new DBConfig();
        $db2 -> config();
        $db2 -> conn();
         $db3 = new DBConfig();
        $db3 -> config();
        $db3 -> conn();
    include'class/podesavanja.php';

    if(isset($lang))
        $gllang=$lang;
    else
        $gllang='sr';
    
    if($lang==""){
       $gllang='sr'; 
    }



    $link="page.link_".$gllang;
    if($page!="" && $page!="index")
        $where=" WHERE ".$link."='".$url_params[3]."'";
  
    else
        $where=" WHERE page.link_$gllang='home'";
    
    if($page=="home" || $page=="" || $page=="index")
        $where=" WHERE page.link_$gllang='home'";

    //Definisanje jezika za izvlacenje iz baze
    $metakey="key_".$gllang;
    $metadesc="metadesc_".$gllang;
    $metatitle="title_".$gllang;
    $naziv="naziv_".$gllang;
    $opis="opis_".$gllang;
    
    
    
    if($page=="page" || $page=="home" || $page==""){
    //Izvlacenje meta tagova
    $query="SELECT page.".$metakey.", page.".$metadesc.",page.".$metatitle.", page.".$naziv.", page.".$opis." FROM page ".$where;

    $db->queryDB($query);
    if($db->numrowDB()>0){
    $row=$db -> selectDB();
   
    //Definisanje meta tagova
    $title=($row[$metatitle]!="" ? $row[$metatitle] : $row[$naziv]." - ".$sitename);
    $desc=($row[$metadesc]!="" ? $row[$metadesc] : substr(strip_tags($row[$opis]),0,150));
    $key=($row[$metakey]!="" ? $row[$metakey] : '');
		
		if($page==''){
		 $h2="Rent a car Beograd, odlične cene - AR renta car aerodrom Nikola Tesla Beograd.";}
    
    }
    else{
      
    }
    }
    else{
        if($page=="lokacije"){
        $title="Lokacije - Ar Rent a Car Beograd";
        $desc="Kontaktirajte nas za više informacija i raspitajte se o svim pogodnostima koje nudimo.";
			$h2="Naša agencija se nalazi na svim velikim aerodromima u Srbiji. Preuzmite vozilo na lokaciji po vašoj želji.
";
    }
    
     if($page=="locations"){
        $title="Locations - Ar Rent a Car Belgrade";
        $desc="Contact us for more information and check our best prices.";
    }
     if($page=="vozni-park"){
        $title="Vozni park - Ar Rent a Car Beograd";
        $desc="Pogledajte sva naša vozila, sigurni smo da ćete pronaći neko vozilo za sebe.";
		 $h2="Pogledajte našu sjajnu ponudu vozila i rezervišite svoje vozilo na vreme!";
    }
    
    if($page=="rent-a-car-nis"){
        $title="Rent a car Niš, AR rent a car aerodrom Niš";
        $desc="Rent a car Niš - Pogledajte sva naša vozila i rentirajte vozilo koje će vas čekati na aerodromu u Nišu, sigurni smo da ćete pronaći neko vozilo za sebe.";
		$h2="Rent a car Niš - lako dostupan i pristupačan. Auto možete preuzeti i na aerodromu Konstantin Veliki u Nišu.";
    }
    
    if($page=="rent-a-car-kraljevo"){
        $title="Rent a car Kraljevo, AR rent a car aerodrom Morava - Kraljevo";
        $desc="Rent a car Kraljevo - Pogledajte sva naša vozila i rentirajte vozilo koje će vas čekati na aerodromu u Kraljevu, sigurni smo da ćete pronaći neko vozilo za sebe.";
		$h2="Ar rent a car Kraljevo vam nudi veliki izbor automobila svih klasa. Auto možete preuzeti i na aerodromu Morava u Kraljevu.";
    }
    
    if($page=="our-vehicle"){
        $title="Our Vehicle - Ar Rent a Car Belgrade";
        $desc="Check all vehicles from our offer and choose some for you.";
    }



    
    if($page=="blog-list"){
        if($gllang=="sr"){
        $title="Blog - Ar Rent a Car Beograd";
        $desc="Pogledajte listu svih blogova, informišite se redovno o najnovijim dešavanjima.";
			$h2="Prilikom izbora i rezervacije vozila pogledajte naše blogove, sigurno ćete naići na neke korisne informacije.";
        }
        else{
           $title="Blog-list - Ar Rent a Car Belgrade";
            $desc="Check all blog posts, and find all infromations about our rental agency.";  
        }
    }


        
    if($page=="iznajmljivanje-vozila" || $page=="car-rental"){
		
        $id=$url_params[4];
        $query="SELECT * FROM cars WHERE id=$id";
        $db->queryDB($query);
        if($db->numrowDB()>0){
        $row=$db->selectDB();
        $opis="opis_".$gllang; 
        if($gllang=="sr"){
            $title=$xml->rent->$gllang." - ".$row['naziv']." - Ar rent a car Beograd";
            $desc=($row[$opis]!="" ? substr(strip_tags($row[$opis]),0,255) : "Detalji za vozilo:".$row['naziv']);
        }
        else{
             $title=$xml->rent->$gllang." - ".$row['naziv']." - Ar rent a car Belgrade";
            $desc=($row[$opis]!="" ? substr(strip_tags($row[$opis]),0,255) : "Details for vehicle:".$row['naziv']);
        }
        }
        else{
              header('HTTP/1.1 404 Not Found');

                include '404.php';
                exit();
        }
    }

    $query="SELECT * FROM blog WHERE link_$gllang='".$url_params[3]."'";
   
    $db->queryDB($query);
    if($db->numrowDB()>0){
       $row=$db -> selectDB(); 
    $title=($row[$metatitle]!="" ? $row[$metatitle] : $row[$naziv])." - Ar Rent a Car Beograd Aerodrom";
    $desc=($row[$metadesc]!="" ? $row[$metadesc] : substr(strip_tags($row[$opis]),0,150));
    $key=($row[$metakey]!="" ? $row[$metakey] : '');
		$h2="Sve najnovije informacije vezane za rent a car Beograd možete pronaći ovde kod nas.";
    }


    
    }

    //de
    if($page=="unser-fahrzeug"){

        $title="Unser Fahrzeug - Ar Rent a Car Belgrad";
        $desc="Überprüfen Sie alle Fahrzeuge aus unserem Angebot und wählen Sie einige für Sie aus.";

    }
    
   
    //OG images
    if($page=="" || $page=="home"){
        $ogimage="http://www.avaco.gw.in.rs/assets/images/logo.svg";
    }
    else if($page=="iznajmljivanje-vozila"){
        $id=$url_params[4];
        $query="SELECT * FROM cars WHERE id=$id";
        $db->queryDB($query);
        $row=$db->selectDB();

        $sl= get_first_image($row['slike']);
        
        $ogimage='http://www.avaco.gw.in.rs'.str_replace('"','',safeecho($sl));
    }
    else{
        $ogimage="http://www.avaco.gw.in.rs/assets/images/logo.svg";
    }
  
    
    if ($gllang!="sr" && $gllang!="en" && $gllang!="de") {
    $actual_link= "http://www.avaco.gw.in.rs";
    header("HTTP/1.1 301 Moved Permanently"); 
        header("Location: $actual_link"); 
        exit();
}


 
?>
<!DOCTYPE html>
<html lang="<?=$gllang;?>">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1">
	<meta name="description" content="<?=$desc;?>">
    <?php
    if($page==""):
    ?>
        <meta name="keywords" content="rent a car, rent a car Beograd, rent a car Beograd aerodrom, rent a car Belgrade, povoljne cene, najam auta, brza realizacija, povoljni najmovi, niske cene, najjeftiniji rent a car, poslovna ponuda, kratkoročni, dugoročni, leasing ili kredit, rent a car Aerodrom Beograd, rent a car Beograd cene, najam kombi vozila Beograd"/>
<?php endif;?>

        <meta name="robots" content="index, follow" />
        <meta name="distribution" content="global"/>

        <meta property="og:title" content="<?=$title;?>" />
        <meta property="og:description" content="<?=$desc;?>" />
        <meta property="og:type" content="website" />
        <meta property="og:url" content="<?=str_replace(":443/","/",full_url());?>" />
        <meta property="og:image" content="<?=$ogimage;?>" />

        <meta name="twitter:card" content="summary">
        <meta name="twitter:title" content="<?=$title;?>">
        <meta name="twitter:description" content="<?=$desc;?>">
        <meta name="twitter:image" content="<?=$ogimage;?>">
        
        <meta name="googlebot" content="noodp">
        
	<link rel="icon" 
      type="image/jpg"  
      href="/assets/favicon.jpg">
	<title><?=$title;?></title>

    <link rel="stylesheet" href="/assets/css/bootstrap-grid.min.css">
    <link rel="stylesheet" href="/assets/css/bootstrap-reboot.min.css">




</head>

<body class="page__home">
	
	<script type="application/ld+json">
            {
                "@context": "https://schema.org",
                "@type": "ProfessionalService",
                "description": "<?=$desc;?>",
                "name": "Ar rent a car Beograd",
                "image": "https://www.avaco.gw.in.rs/assets/images/logo.svg",
                "url": "https://www.avaco.gw.in.rs",
                "telephone": "+381606911111",
                "priceRange": "15-70€/day",
                "sameAs": [

                  "https://www.facebook.com/arrentacarbeograd"
	
                ],
                "address": {
                    "@type": "PostalAddress",
                    "streetAddress": "Aerodrom Beograd 59",
                    "addressLocality": "Beograd",
                    "postalCode": "11180",
                    "addressCountry": "RS"
                }
            }
        </script>


    <header>
        <div class="inobar">
            <div class="container">
                <div class="row">

                </div>
            </div>
        </div>
        <div class="mainheader">
            <div class="container">
                <div class="d-flex">
                    <div class="logo">
                        <img src="/assets/img/logo.svg" alt="<?=$xml->logoname->$gllang;?>"/>
                    </div>
                </div>
            </div>
        </div>
    </header>
	
    <div class="container" style="padding:5px 0px; background: white;">

        <?php if($page==""):?><h1 style="font-size:16px; text-align: center; <?php if(is_mobile()):?>margin-top: 45px;<?php endif;?>"><?php else:?><h2 style="font-size:16px;  text-align: center; <?php if(is_mobile()):?>margin-top: 45px;<?php endif;?>"><?php endif;?>
          <?php if($gllang=="sr") {
	if($h2!=''){
              echo $h2;
	} else {
	$link=$url_params[3];

                                                            $query="SELECT * FROM page WHERE link_sr='".$link."' OR link_en='".$link."' OR link_de='".$link."'";
                                                            $db->queryDB($query);
                                                            $row=$db -> selectDB(); 
		echo $row['h2_sr'];
	}
          }
          elseif($gllang=="en"){
              echo "Rent a car Belgrade, AR rent a car - car rental, Belgrade Nikola Tesla Airport, Konstantin Veliki Nis Airport, Morava Kraljevo Airport.";
          }
                elseif($gllang=="de"){
                    echo "Rent a car Belgrad, AR Autovermietung - Autovermietung, Flughafen Nikola Tesla Belgrad, Flughafen Konstantin Veliki Nis, Flughafen Morava Kraljevo.";
                }
          ?>
        <?php if($page==""):?></h1><?php else:?></h2><?php endif;?>
    </div>
	<!-- Header -->
	<header class="site-header">
            <?php
            $_SESSION['gllang']=$gllang;
            ?>
		<div class="mobile-top-panel"></div>
		<div class="mobile-top-panel__fixed">
			<div class="container">
				<div class="navbar navbar-default navbar-fixed-top" role="navigation">
					<div class="navbar-header">
						<button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
							<span class="sr-only">Toggle navigation</span>
							<span class="icon-bar"></span>
							<span class="icon-bar"></span>
							<span class="icon-bar"></span>
						</button>
					</div>
					<div class="menu-navigation navbar-collapse collapse">

						<!-- Left nav -->
						<ul class="menu-navigation__list nav navbar-nav">
                                                    <li class="current"><a href="<?=($gllang=="sr" ? "/" : "/$gllang/");?>" data-hover="Home" title="Rent a car Beograd">Rent a car Beograd</a></li>
							<li><a href="/<?=$gllang;?>/<?=$xml->ln_voznipark->$gllang;?>/" data-hover="<?=$xml->cars->$gllang;?>"><?=$xml->cars->$gllang;?></a></li>
                                                        
                                                            <?php
                                                $query="SELECT * FROM menu WHERE id_master=0 AND red<100 ORDER BY red";
                                                $db->queryDB($query);
                                                $naziv="naziv_".$gllang;
                                                $link="link_".$gllang;
                                                
                                                while($row=$db -> selectDB()):
                                                    $br=0;
                                                    //echo $row['id']."<br>";
                                                    $query3="SELECT * FROM page WHERE id=".$row['id_page'];
                                                    $db3->queryDB($query3);
                                                    $row3=$db3 -> selectDB();
                                                    
                                                ?>
                                            	
                                                <?php
                                                $query2="SELECT menu.naziv_sr, menu.naziv_en, page.link_sr, page.link_en FROM menu INNER JOIN page ON menu.id_page=page.id WHERE menu.id_master=".$row['id']." ORDER BY menu.red";
                                                $db2->queryDB($query2);
                                                $naziv2="naziv_".$gllang;
                                                $link2="link_".$gllang;
                                                if($db2->numrowDB()>0):
                                                ?>
                                                <li><a href="/<?=$gllang;?>/page/<?=$row[$link];?>/"><?=$row[$naziv];?> <i class="icon-arrow-down-sign-to-navigate"></i></a>
                                                    <ul class="sub-menu dropdown-menu">
                                                        <?php
                                                        while($row2=$db2 -> selectDB()):
                                                            ?>
                                                        <li><a href="/<?=$gllang;?>/page/<?=$row2[$link];?>/"><?=$row2[$naziv];?></a></li>
                                                        <?php
                                                        endwhile;
                                                        ?>
                                                    </ul>
                                                </li>
                                                <?php else:?>
                                                
                                                <li><a href="/<?=$gllang;?>/page/<?=$row3[$link];?>/"><?=$row[$naziv];?></a></li>
                                                <?php endif;?>
                                                <?php endwhile;?>
                                                
                                                <li><a href="#" data-remodal-target="modal" data-hover="<?=$xml->booknow->$gllang;?>"><?=$xml->booknow->$gllang;?></a></li>
                                                <?php
                                                $query="SELECT * FROM menu WHERE id_master=0 AND red>100 ORDER BY red";
                                                $db->queryDB($query);
                                                $naziv="naziv_".$gllang;
                                                $link="link_".$gllang;
                                                
                                                while($row=$db -> selectDB()):
                                                    $br=0;
                                                    //echo $row['id']."<br>";
                                                    $query3="SELECT * FROM page WHERE id=".$row['id_page'];
                                                    $db3->queryDB($query3);
                                                    $row3=$db3 -> selectDB();
                                                    
                                                ?>
                                            	
                                                <?php
                                                $query2="SELECT menu.naziv_sr, menu.naziv_en, page.link_sr, page.link_en FROM menu INNER JOIN page ON menu.id_page=page.id WHERE menu.id_master=".$row['id']." ORDER BY menu.red";
                                                $db2->queryDB($query2);
                                                $naziv2="naziv_".$gllang;
                                                $link2="link_".$gllang;
                                                if($db2->numrowDB()>0):
                                                ?>
                                                <li><a href="/<?=$gllang;?>/page/<?=$row[$link];?>/"><?=$row[$naziv];?> <i class="icon-arrow-down-sign-to-navigate"></i></a>
                                                    <ul class="sub-menu dropdown-menu">
                                                        <?php
                                                        while($row2=$db2 -> selectDB()):
                                                            ?>
                                                        <li><a href="/<?=$gllang;?>/page/<?=$row2[$link];?>/"><?=$row2[$naziv];?></a></li>
                                                        <?php
                                                        endwhile;
                                                        ?>
                                                    </ul>
                                                </li>
                                                <?php else:?>
                                                <?php if($gllang=="en" && $row3[$link]=="rent-a-truck"){}
                                                else{?>
                                                <li><a href="/<?=$gllang;?>/page/<?=$row3[$link];?>/"><?=$row[$naziv];?></a></li>
                                                <?php } ?>
                                                <?php endif;?>
                                                <?php endwhile;?>
                                                <li><a href="/<?=$gllang;?>/<?=$xml->ln_location->$gllang;?>/" data-hover="<?=$xml->location->$gllang;?>"><?=$xml->location->$gllang;?></a></li>
                                                <li><a href="/<?=$gllang;?>/blog-list/">Blog</a></li>
						
						</ul>

					</div>
					<!--/.nav-collapse -->
				</div>
				<div class="social-list">
					<span class="social-list__text">Find us here:</span>
					<ul class="social-list__icons">
						<li><a target="_blank" href="#"><i class="icon-facebook-logo"></i></a></li>
						
					</ul>
				</div>
			</div>
		</div>
		<div class="header-container_wrap container">
			<div class="header-container__flex">
				<div class="logo">
					<a href="/<?=$gllang;?>/">
                        <img src="/assets/images/rentacar-beograd-logo.svg" alt="Rent a car Beograd | Srbija | Aerodrom Beograd" />
					</a>
				</div>
				
				<div class="phone_block">

                     <a href="/en/" style="color: white;font-size: 14px;"><img src="/assets/images/united-kingdom.png" style="height: 25px;" alt="Rent a car Beograd Aerodrom" title="Rent a car Beograd Aerodrom"/></a>
                    <a href="/de/" style="color: white;font-size: 14px;"><img src="/assets/images/de.png" style="height: 25px;" alt="Rent a car Belgrad"/></a>
                    <a href="/sr/" title="Rent a car Beograd" style="color: white;font-size: 14px;"><img src="/assets/images/serbia.png" style="height:25px;" alt="Rent a car Beograd" title="Rent a car Beograd, rentirajte vozilo u Beogradu, Rent a car Beograd Aerodrom"></a><br/><?php if(is_mobile()):?><br><?php endif;?>
					<span><i class="icon-telephone"></i> <a href="tel:+381606911111" class="tel">+381606911111</a></span>
                                        <small <?php if(is_mobile()):?>style="display: block; margin-top: 15px; padding:0px;"<?php endif;?>><?php if(!is_mobile()):?><?=$xml->pozovinasodmah->$gllang;?><?php endif;?> <a href="viber://contact?number=%2B381606911111"><img src="/assets/images/viber.svg" alt="viber" style="    height: 35px;
    margin-right: 5px;
    margin-left: 10px;"/></a><a href="https://wa.me/381606911111"><img src="/assets/images/whatsapp.svg" alt="whats app" style="    height: 35px;"/></a></small>
				</div>
			</div>
		</div>
		<div class="header-navigation-wrap stickUp">
			<!-- Navbar fixed top -->
			<div class="navbar navbar-default navbar-fixed-top" role="navigation">
				<div class="container">
					<div class="navbar-header">
						<button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
							<span class="sr-only">Toggle navigation</span>
							<span class="icon-bar"></span>
							<span class="icon-bar"></span>
							<span class="icon-bar"></span>
						</button>
					</div>
					<div class="menu-navigation navbar-collapse collapse">

						<!-- Left nav -->
						<ul class="menu-navigation__list nav navbar-nav">
							<li class="current"><a href="<?=($gllang=="sr" ? "/" : "/$gllang/");?>" data-hover="Home">Rent a car Beograd</a></li>
							<li><a href="/<?=$gllang;?>/<?=$xml->ln_voznipark->$gllang;?>/" data-hover="<?=$xml->cars->$gllang;?>"><?=$xml->cars->$gllang;?></a></li>
                                                            <?php
                                                $query="SELECT * FROM menu WHERE id_master=0 AND red<100 ORDER BY red";
                                                $db->queryDB($query);
                                                $naziv="naziv_".$gllang;
                                                $link="link_".$gllang;
                                                
                                                while($row=$db -> selectDB()):
                                                    $br=0;
                                                    //echo $row['id']."<br>";
                                                    $query3="SELECT * FROM page WHERE id=".$row['id_page'];
                                                    $db3->queryDB($query3);
                                                    $row3=$db3 -> selectDB();
                                                    
                                                ?>
                                            	
                                                <?php
                                                $query2="SELECT menu.naziv_sr, menu.naziv_en, page.link_sr, page.link_en FROM menu INNER JOIN page ON menu.id_page=page.id WHERE menu.id_master=".$row['id']." ORDER BY menu.red";
                                                $db2->queryDB($query2);
                                                $naziv2="naziv_".$gllang;
                                                $link2="link_".$gllang;
                                                if($db2->numrowDB()>0):
                                                ?>
                                                <li><a href="/<?=$gllang;?>/page/<?=$row[$link];?>/"><?=$row[$naziv];?> <i class="icon-arrow-down-sign-to-navigate"></i></a>
                                                    <ul class="sub-menu dropdown-menu">
                                                        <?php
                                                        while($row2=$db2 -> selectDB()):
                                                            ?>
                                                        <li><a href="/<?=$gllang;?>/page/<?=$row2[$link];?>/"><?=$row2[$naziv];?></a></li>
                                                        <?php
                                                        endwhile;
                                                        ?>
                                                    </ul>
                                                </li>
                                                <?php else:?>
                                                
                                                <li><a href="/<?=$gllang;?>/page/<?=$row3[$link];?>/"><?=$row[$naziv];?></a></li>
                                                <?php endif;?>
                                                <?php endwhile;?>
                                                <li><a href="#" data-remodal-target="modal" data-hover="<?=$xml->booknow->$gllang;?>"><?=$xml->booknow->$gllang;?></a></li>
						<?php
                                                $query="SELECT * FROM menu WHERE id_master=0 AND red>100 ORDER BY red";
                                                $db->queryDB($query);
                                                $naziv="naziv_".$gllang;
                                                $link="link_".$gllang;
                                                
                                                while($row=$db -> selectDB()):
                                                    $br=0;
                                                    //echo $row['id']."<br>";
                                                    $query3="SELECT * FROM page WHERE id=".$row['id_page'];
                                                    $db3->queryDB($query3);
                                                    $row3=$db3 -> selectDB();
                                                    
                                                ?>
                                            	
                                                <?php
                                                $query2="SELECT menu.naziv_sr, menu.naziv_en, page.link_sr, page.link_en FROM menu INNER JOIN page ON menu.id_page=page.id WHERE menu.id_master=".$row['id']." ORDER BY menu.red";
                                                $db2->queryDB($query2);
                                                $naziv2="naziv_".$gllang;
                                                $link2="link_".$gllang;
                                                if($db2->numrowDB()>0):
                                                ?>
                                                <li><a href="/<?=$gllang;?>/page/<?=$row[$link];?>/"><?=$row[$naziv];?> <i class="icon-arrow-down-sign-to-navigate"></i></a>
                                                    <ul class="sub-menu dropdown-menu">
                                                        <?php
                                                        while($row2=$db2 -> selectDB()):
                                                            ?>
                                                        <li><a href="/<?=$gllang;?>/page/<?=$row2[$link];?>/"><?=$row2[$naziv];?></a></li>
                                                        <?php
                                                        endwhile;
                                                        ?>
                                                    </ul>
                                                </li>
                                                <?php else:?>
                                                <?php if($gllang=="en" && $row3[$link]=="rent-a-truck"){}
                                                else{?>
                                                <li><a href="/<?=$gllang;?>/page/<?=$row3[$link];?>/"><?=$row[$naziv];?></a></li>
                                                <?php } ?>
                                                <?php endif;?>
                                                <?php endwhile;?>
                                                <li><a href="/<?=$gllang;?>/<?=$xml->ln_location->$gllang;?>/" data-hover="<?=$xml->location->$gllang;?>"><?=$xml->location->$gllang;?></a></li>
                                                <li><a href="/<?=$gllang;?>/blog-list/">Blog</a></li>
                                                </ul>
                                                
					</div>
					<!--/.nav-collapse -->
				</div>
				<!--/.container -->
			</div>
		</div>

	</header>
	<!-- // Header -->
	<?php

            if($page=="vozni-park" || $page=="our-vehicle" || $page=="unser-fahrzeug")
            {
               
                    include "application/cars.php";
                
            }
            elseif($page=="locations" || $page=="lokacije"){
                include "application/location.php";
            }
            elseif($page=="iznajmljivanje-vozila" || $page=="car-rental"){
                include "application/iznajmljivanje-vozila.php";
            }
            elseif($page=="rent-a-car-nis"){
                include "application/rent-a-car-nis.php";
            }
            elseif($page==""){
                include "application/home.php";
            }
            else{
            include "application/".$page.".php";
            }
        ?>
	<!-- Footer -->
	<footer class="site-footer">
            <section style="background: whitesmoke; padding:10px;">
                <div class="container">
				<div class="row">
                                    <div class="col-xs-12" style="color:black; text-align: center;">
                                         <?=$xml->ceneinfo->$gllang;?>
                                    </div>
                                </div>
                </div>
            </section>
		<section class="site-footer__top-panel">
			<div class="container">
				<div class="row">
					<div class="col-xs-12 col-sm-4">
						<div class="top-panel__info">
							<i class="fa fa-check-circle"></i>
							<strong><?=$xml->fastbook->$gllang;?></strong>
						</div>
					</div>
					<div class="col-xs-12 col-sm-4">
						<div class="top-panel__info">
							<i class="icon-commerce"></i>
							<strong><?=$xml->nocreditcards->$gllang;?></strong>
						</div>
					</div>
					<div class="col-xs-12 col-sm-4">
						<div class="top-panel__info">
							<i class="fa fa-map-marker"></i>
							<strong><?=$xml->locationonairport->$gllang;?></strong>
						</div>
					</div>
				</div>
			</div>
		</section>
		<section class="box-elements">
			<div class="container">
				<div class="row">
					<div class="col-xs-12 col-sm-6 col-md-12 col-lg-3">
                                            <figure class="footer_logo">
                                                <div>
 <img  src="/assets/images/logo.svg" alt="Ar Rent a car Beograd" /><br><br>
 <div >Ar Rent a car Beograd, Niš, Aranđelovac</div>
 <div >+381606911111</div>
  <div >https://www.avaco.gw.in.rs</div>
</div>
                                            </figure>
					</div>
					<div class="col-xs-12 col-sm-6 col-md-4 col-lg-3">
						
						<ul class="footer-list">
							<li class="current"><a href="/" data-hover="Rent a car Beograd - Home">Rent a car Beograd</a></li>
                                                        
                                                        <?php if ($gllang=="sr"):?>
                                                        <li><a href="/<?=$gllang;?>/">Rent a car Aerodrom Beograd</a></li>
                                                        <li class="current"><a href="/<?=$gllang;?>/rent-a-car-nis/" data-hover="Home">Rent a car Niš</a></li>
                                                      
                                                        <li><a href="/<?=$gllang;?>/page/rent-a-car-arandjelovac">Rent a car Aranđelovac</a></li>
                                                      
							                            <li><a href="/<?=$gllang;?>/rent-a-car-nis/">Rent a car Niš Aerodrom</a></li>
                                                       
                                                        <li><a href="/<?=$gllang;?>/page/rent-a-car-surcin">Rent a car Beograd Surčin Aerodrom</a></li>
								<?php if($gllang!='en'){ ?>
         <li><a href="https://www.avaco.gw.in.rs/sr/page/iznajmljivanje-luksuznih-automobila-beograd/" target="_blank">Iznajmljivanje luksuznih automobila Beograd</a></li>	<?php } ?>
			                                             
                                                       
                                                       
                                                     <!--   <li><a href="https://www.iznajmljivanje-kampera.com/" target="_blank">EFEX iznajmljivanje kampera</a></li> -->
                                                    
                                                        <?php endif;?>
                                                        
                                                            <?php
                                                $query="SELECT * FROM menu WHERE id_master=0 ORDER BY red";
                                                $db->queryDB($query);
                                                $naziv="naziv_".$gllang;
                                                $link="link_".$gllang;
                                                
                                                while($row=$db -> selectDB()):
                                                    $br=0;
                                                    //echo $row['id']."<br>";
                                                    $query3="SELECT * FROM page WHERE id=".$row['id_page'];
                                                    $db3->queryDB($query3);
                                                    $row3=$db3 -> selectDB();
                                                    
                                                ?>
                                            	
                                                <?php
                                                $query2="SELECT menu.naziv_sr, menu.naziv_en, page.link_sr, page.link_en FROM menu INNER JOIN page ON menu.id_page=page.id WHERE menu.id_master=".$row['id']." ORDER BY menu.red";
                                                $db2->queryDB($query2);
                                                $naziv2="naziv_".$gllang;
                                                $link2="link_".$gllang;
                                                if($db2->numrowDB()>0):
                                                ?>
                                                <li><a href="/<?=$gllang;?>/page/<?=$row[$link];?>/"><?=$row[$naziv];?> <i class="icon-arrow-down-sign-to-navigate"></i></a>
                                                    <ul class="sub-menu dropdown-menu">
                                                        <?php
                                                        while($row2=$db2 -> selectDB()):
                                                            ?>
                                                        <li><a href="/<?=$gllang;?>/page/<?=$row2[$link];?>/"><?=$row2[$naziv];?></a></li>
                                                        <?php
                                                        endwhile;
                                                        ?>
                                                    </ul>
                                                </li>
                                                <?php else:?>
                                                
                                                <li><a href="/<?=$gllang;?>/page/<?=$row3[$link];?>/"><?=$row[$naziv];?></a></li>
                                                <?php endif;?>
                                                <?php endwhile;?>
                                                <li><a href="https://plus.google.com/117340895059413031250" target="_blank">Ar rent a car na Google +</a></li>
                                                </ul>
					</div>
					<div class="col-xs-12 col-sm-6 col-md-4 col-lg-3">
						
						<ul class="footer-list">
                            <?php if ($gllang=="sr"):?>
							 <li><a href="https://www.ekorentacar.rs/" target="_blank">EKO rent a car Beograd</a></li>
   
                                                        <li><a href="/<?=$gllang;?>/page/rent-a-car-bez-depozita">Rent a car Beograd</a></li>
                                                        
                                <li><a href="/<?=$gllang;?>/page/jeftin-rent-a-car-beograd">Jeftin rent a car Beograd</a></li>
                                <li><a href="/<?=$gllang;?>/page/najjeftiniji-rent-a-car-beograd">Najjeftiniji rent a car Beograd</a></li>
                             <!--   <li><a href="/<?=$gllang;?>/page/iznajmljivanje-kampera/">Najam kampera</a></li>
                                <li><a href="/<?=$gllang;?>/page/iznajmljivanje-kampera/">Rentiranje kampera</a></li>
                                <li><a href="/<?=$gllang;?>/page/iznajmljivanje-kamp-prikolica/">Iznajmljivanje kamp prikolica</a></li> -->
                               
                                <li><a href="/<?=$gllang;?>/page/rent-a-car-beograd-zemun">Rent A Car Beograd - Zemun</a></li>
                                <li><a href="/<?=$gllang;?>/page/rent-a-car-beograd-vracar">Rent A Car Beograd - Vračar</a></li>
							    <li><a href="https://www.rentacarsarajevo.com/" target="_blank">Rent A Car Sarajevo</a></li>
							 <li><a href="https://rentacar-tuzla.com/" target="_blank">Rent A Car Tuzla</a></li>
							

                            <?php endif;?>

                                                    <li><a href="/<?=$gllang;?>/<?=$xml->ln_voznipark->$gllang;?>/" data-hover="<?=$xml->cars->$gllang;?>"><?=$xml->cars->$gllang;?></a></li>
							<li><a href="#" data-remodal-target="modal" data-hover="<?=$xml->booknow->$gllang;?>"><?=$xml->booknow->$gllang;?></a></li>
						<li><a href="/<?=$gllang;?>/<?=$xml->ln_location->$gllang;?>/" data-hover="<?=$xml->location->$gllang;?>"><?=$xml->location->$gllang;?></a></li>
							<?php if($gllang!='en'){ ?>
										<li><a href="https://www.avaco.gw.in.rs/sr/page/rent-a-car-beograd-za-inostranstvo/" target="_blank">Rent a car Beograd za inostranstvo</a></li>    <?php } ?>
						</ul>
					</div>
					<div class="col-xs-12 col-sm-6 col-md-4 col-lg-3">
						<div class="contact-info">
							<span class="phone_number">
                                                            <i class="icon-telephone"></i> <a href="tel:+381606911111" class="tel">+381606911111</a></span>

							<span class="location_info">
                                                            <i class="fa fa-envelope"></i> <a href="mailto:reservations@avaco.gw.in.rs">reservations@avaco.gw.in.rs</a>
							</span>
                                                    <div class="clearfix"></div>
                                                    <br><br>
                                                    <!-- Go to www.addthis.com/dashboard to customize your tools --> <div class="addthis_sharing_toolbox"></div>
						</div>
					</div>
				</div>
			</div>
		</section>
		<section class="site-footer__bottom-panel">
			<div class="container">
				<div class="row">
					<div class="col-xs-12 col-md-6">
                        <div class="copyright">&copy; <?=date("Y");?> All rights reserved - AR <strong>Rent a car Beograd</strong></div>
					</div>
					<div class="col-xs-12 col-md-6" style="text-align: right;">
						<a href="https://www.global-webmasters.com">Izrada sajta i SEO</a> - Global Webmasters
					</div>
				</div>
			</div>
		</section>

		<a href="#" class="scrollup"><i class="icon-arrow-down-sign-to-navigate"></i></a>

	</footer>
        <button id="jezik" style="height:1px; padding:0px;" data-gllang="<?=$gllang;?>"></button>

	<div class="remodal" data-remodal-id="modal">
		<a data-remodal-action="close" class="remodal-close"></a>
		<!-- // order-details-form  -->
		<form class="order-details-form" id="bookingForm" name="bookingform" method="post" novalidate>
			<div class="inner-form" id="displayinfo">
				<h3><?=$xml->orderform->$gllang;?></h3>
				<div class="clearfix">
					<div id="successBooking">
						<p>Your message was sent successfully!</p>
					</div>
					<div id="errorBooking">
						<p>Something went wrong, try refreshing and submitting the form again.</p>
					</div>
				</div>
				<div class="inner-form__elements">
					<div class="inner-half">
                                                <h5 id="carname"></h5>
                                                
                                                <div class="select-vehicle">
                                                    <select name="car" id="carlist" required="" style="max-width:100%;">
                                                            <option value=""><?=$xml->choosecar->$gllang;?></option>
                                                            <?php
                                                            $query="SELECT * FROM cars ORDER BY redosled";
                                                            $db->queryDB($query);
                                                            while($row=$db->selectDB()):
                                                            ?>
                                                            <option value="<?=$row['id'];?>"><?php if($gllang=='en'){echo $row['naziv_en'];} else if($gllang=='de'){echo $row['naziv_de'];} else {echo $row['naziv'];} ?></option>	
                                                            <?php endwhile;?>
							</select>
						</div>
                                                
							<div class="passengers">
								<span><?=$xml->mestopreuzimanja->$gllang;?>:</span>
								<select name="mestopreuzimanja" id="mestopreuzimanja">
                                                                    <option value="Aerodrom Beograd"><?=$xml->aerodrom->$gllang;?></option>
                                                                    <option value="Aerodrom Nis"><?=$xml->aerodromnis->$gllang;?></option>
                                                                    
                                                                    <option value="Arandjelovac"><?=$xml->arandjelovac->$gllang;?></option>
                                                                    
								</select>
							</div>
							<br>
                                                        <div class="passengers">
								<span><?=$xml->mestovracanja->$gllang;?>:</span>
								<select name="mestovracanja"  id="mestovracanja">
                                                                    <option value="Aerodrom Beograd"><?=$xml->aerodrom->$gllang;?></option>
                                                                    <option value="Aerodrom Nis"><?=$xml->aerodromnis->$gllang;?></option>
                                                                  
                                                                    <option value="arandjelovac"><?=$xml->arandjelovac->$gllang;?></option>
                                                                    
								</select>
							</div>
                                                <br>
						
						<div class="inner-half__width">
							<div class="input-date datetimepicker-wrap">
								<input type="text" name="datumpreuzimanja"  id="datetimepicker1" class="datetimepicker datepicker saveposition" required="" readonly="readonly" placeholder="<?=$xml->datumpreuzimanja->$gllang;?>">
								<i class="icon-calendar-with-a-clock-time-tools"></i>
							</div>
							<div class="input-time">
								<input type="text" name="vremepreuzimanja" id="timepicker1" class="timepicker saveposition" readonly="readonly" placeholder="<?=$xml->vremepreuzimanja->$gllang;?>">
								<i class="icon-clock"></i>
							</div>
						</div>
						<div class="inner-half__width">
							<div class="input-date datetimepicker-wrap">
								<input type="text" name="datumvracanja" id="datetimepicker2" class="datetimepicker datepicker saveposition" required="" readonly="readonly" placeholder="<?=$xml->datumvracanja->$gllang;?>">
								<i class="icon-calendar-with-a-clock-time-tools"></i>
							</div>
							<div class="input-time">
								<input type="text" name="vremevracanja" id="timepicker2" class="timepicker saveposition" readonly="readonly" placeholder="<?=$xml->vremevracanja->$gllang;?>">
								<i class="icon-clock"></i>
							</div>
						</div>
                                                <div class="col-md-6">
                                                    <p style='font-weight:bold;margin-bottom:5px;'><?=$xml->uracunato->$gllang;?></p>
                                                    <ul class='listincluded' style='font-weight:300;margin-bottom:5px;'><li><i class='fa fa-check-square-o' style='position: inherit;    color: green;'></i> <?=$xml->kasko->$gllang;?></li> <li><i class='fa fa-check-square-o' style='position: inherit;    color: green;'></i> <?=$xml->osiguranjeputnika->$gllang;?></li><li><i class='fa fa-check-square-o' style='position: inherit;    color: green;'></i> <?=$xml->neokilometraza->$gllang;?></li><li><i class='fa fa-check-square-o' style='position: inherit;    color: green;'></i> <?=$xml->porez->$gllang;?></li><li><i class='fa fa-check-square-o' style='position: inherit;    color: green;'></i> <?=$xml->oboprema->$gllang;?></li><li><i class='fa fa-check-square-o' style='position: inherit;    color: green;'></i> <?=$xml->sedistazadecu->$gllang;?></li><li><i class='fa fa-check-square-o' style='position: inherit;    color: green;'></i> <?=$xml->prterminal->$gllang;?></li><li><i class='fa fa-check-square-o' style='position: inherit;    color: green;'></i>  <?=$xml->freedatechange->$gllang;?></li></ul>
                                                    
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="text-element checkbox-div">
                                                        <div class="wishes" id="wishes">
                                                            <h6><?=$xml->dodaci->$gllang;?>:</h6>
                                                            <div class="box-checkbox">
                                                                <input type="checkbox" name="dodaci[]" class="dodaci" id="checkbox-05" value="gps">
                                                                <label for="checkbox-05"><?=$xml->gps->$gllang;?></label>
                                                            </div>
                                                            <div class="box-checkbox">
                                                                <input type="checkbox" name="dodaci[]" class="dodaci" id="checkbox-06" value="wifi">
                                                                <label for="checkbox-06"><?=$xml->wifi->$gllang;?></label>
                                                            </div>
                                                            <div class="box-checkbox">
                                                                <input type="checkbox" name="dodaci[]" class="dodaci" id="checkbox-07" value="fullosiguranje">
                                                                <label for="checkbox-07"><?=$xml->fullosiguranje->$gllang;?></label>
                                                            </div>
															 <div class="box-checkbox">
                                                                <input type="checkbox" name="dodaci[]" class="dodaci" id="checkbox-16" value="sedistazadecu">
                                                                <label for="checkbox-16"><?=$xml->sedistazadecu->$gllang;?></label>
                                                            </div>
                                                            
                                                            <div class="box-checkbox">
                                                                <input type="checkbox" name="dodaci[]" class="dodaci" id="checkbox-08" value="sedistazadecu1">
                                                                <label for="checkbox-08"><?=$xml->sedistazadecu1->$gllang;?></label>
                                                            </div>
															 <div class="box-checkbox">
                                                                <input type="checkbox" name="dodaci[]" class="dodaci" id="checkbox-14" value="sedistazadecu2">
                                                                <label for="checkbox-14"><?=$xml->sedistazadecu2->$gllang;?></label>
                                                            </div>
															 <div class="box-checkbox">
                                                                <input type="checkbox" name="dodaci[]" class="dodaci" id="checkbox-15" value="sedistazadecu3">
                                                                <label for="checkbox-15"><?=$xml->sedistazadecu3->$gllang;?></label>
                                                            </div>
                                                            
                                                            <div class="box-checkbox">
                                                                <input type="checkbox" name="dodaci[]" class="dodaci" id="checkbox-09" value="dodatnivozac">
                                                                <label for="checkbox-09"><?=$xml->dodatnivozac->$gllang;?></label>
                                                            </div>
                                                             <!--
                                                            <div class="box-checkbox">
                                                                <input type="checkbox" name="dodaci[]" class="dodaci" id="checkbox-10" value="lancizasneg">
                                                                <label for="checkbox-10"><?=$xml->lancizasneg->$gllang;?></label>
                                                            </div>
                                                             -->
                                                           <!-- <div class="box-checkbox">
                                                                <input type="checkbox" name="dodaci[]" class="dodaci" id="checkbox-11" value="krovnikofer">
                                                                <label for="checkbox-11"><?=$xml->krovnikofer->$gllang;?></label>
                                                            </div> -->
                                                            <div class="box-checkbox">
                                                                <input type="checkbox" name="dodaci[]" class="dodaci" id="checkbox-12" value="zelenikarton">
                                                                <label for="checkbox-12"><?=$xml->zelenikarton->$gllang;?></label>
                                                            </div>
                                                <!--             <div class="box-checkbox">
                                                                <input type="checkbox" name="dodaci[]" class="dodaci" id="checkbox-13" value="decijakolica">
                                                                <label for="checkbox-13"><?=$xml->decijakolica->$gllang;?></label>
                                                            </div> -->
                                                        </div>
                                                    </div>
                                                    
                                                </div>
                                                <div class="col-md-12">
                                                    <div id="ukcena"></div>
                                                </div>
                                                
					</div>
					<div class="inner-half">
						<h5><?=$xml->contactinformations->$gllang;?></h5>
						<div class="inner-half__width">
							<div class="first-name">
								
								
                                                            <input type="text" name="firstname" class="saveposition" id="firstname" placeholder="<?=$xml->name->$gllang;?>*" required="">
							</div>
							<div class="last-name">
                                                            <input type="text" name="lastname" class="saveposition" id="lastname" placeholder="<?=$xml->lastname->$gllang;?>*" required="">
							</div>
						</div>

						<div class="inner-half__width">
							<div class="your-phone">
								<input type="tel" name="phone" class="saveposition" id="phone" placeholder="<?=$xml->phone->$gllang;?> (+381)*" required="">
							</div>
							<div class="email">
								<input type="email" name="email" class="saveposition" id="email" placeholder="E-mail*"  required="" style="font-size: 16px;
    line-height: 1.2em;
    font-weight: 300;
    padding: 6px 40px 8px 13px;
    width: 100%;">
                                                                
							</div>
						</div>
                                                <div class="inner-half__width">
							<div class="your-phone">
								<input type="text" name="datumrodjenja" class="datepicker" id="datebirth" placeholder="<?=$xml->datumrodjenja->$gllang;?>*" required="">
							</div>
							<div class="your-phone">
								<input type="text" name="brleta" id="brleta" placeholder="<?=(is_mobile() ? $xml->brletamobile->$gllang : $xml->brleta->$gllang);?>*" required="">
							</div>
						</div>
						<div class="specialreguests">
							<textarea name="specialreguests" id="comment" placeholder="<?=$xml->writecomment->$gllang;?>"></textarea>
							
						</div>
                                                <br>
                                                <div class="text-element checkbox-div">
							<div class="wishes">
						<div class="box-checkbox">
                                                    <input type="checkbox" name="uslovikoriscenja" id="checkbox-04" checked="" required="">
							<label for="checkbox-04"><?=$xml->iaccept->$gllang;?> <a href="<?=$xml->termslink->$gllang;?>" target="_blank" style="color:blue;"><?=$xml->terms->$gllang;?></a></label>
                                                        <div id="error" style="display:none; color:red"><?=$xml->termserror->$gllang;?></div>
						</div>
                                                            </div>
                                                    </div>
                                                <div id="dodatniinfo"></div>
                                                <p><i class='fa fa-check-square-o' style='position: inherit;    color: green;'></i> <?=$xml->besplatnootkazivanje->$gllang;?><br>
                                                    <i class='fa fa-check-square-o' style='position: inherit;    color: green;'></i> <?=$xml->placanjepripreuzimanju->$gllang;?>
                                                </p>
                                                <button type="submit" class="btn" id="rezervisidugme"><?=$xml->reserve->$gllang;?></button>
					</div>
				</div>
				
			</div>
		</form>
		<!-- // order-details-form  -->
	</div>


        <?php
        if(!is_mobile()):?>
        <a href="#" class="scrollup" data-up="1"></a> 
        <?php else:?>
        <?php if($kamperi==1):?>
                <div class="footerlinks">

                    <div class="col-xs-12" style="background: #d9b034;text-align: center; padding: 15px 10px;"><a href="tel:+381605665000" style="color:white;padding: 15px 10px; text-transform: uppercase;"><?=$xml->callnow->$gllang;?></a></div>
                </div>
        <?php else:?>
        <div class="footerlinks">
            <div class="col-xs-6" style="background: #9e790c;text-align: center; padding: 15px 10px;">
                <a href="#modal" data-remodal-target="modal" data-hover="<?=$xml->booknow->$gllang;?>" style="color:white;padding: 15px 10px; text-transform: uppercase;"><?=$xml->booknow->$gllang;?></a></div>
            <div class="col-xs-6" style="background: #d9b034;text-align: center; padding: 15px 10px;"><a href="tel:+381606911111" style="color:white;padding: 15px 10px; text-transform: uppercase;"><?=$xml->callnow->$gllang;?></a></div>
        </div>
        <?php endif;?>
        <?php endif;?>
        <!-- end scroll to top of the page--> 
        
	<!-- //Footer -->
	<!-- Google map -->


        
	<script src="/assets/js/jquery.1.12.4.min.js"></script>
	<script src="/assets/js/plugins/bootstrap.min.js"></script>
	<script src="/assets/js/plugins/jquery.smartmenus.min.js"></script>
	<script src="/assets/js/plugins/jquery.smartmenus.bootstrap.js"></script>
<?php
if($page!=""):
?>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.js"></script>
<?php
endif;
?>
	<!--<script src="/assets/js/plugins/jquery.nivo.slider.js"></script>-->
	<script src="/assets/js/plugins/intlTelInput.min.js"></script>
	<script src="/assets/js/plugins/remodal.js"></script>
	<script src="/assets/js/plugins/stickup.min.js"></script>
	<script src="/assets/js/plugins/tool.js"></script>
	<script src="/assets/js/plugins/jquery.form.js"></script>
        <script src="/assets/js/plugins/jquery.validate.min.js"></script>
	<script src="/assets/js/plugins/moment.js"></script>
	<script src="/assets/js/plugins/bootstrap-datetimepicker.min.js"></script>


<script src="https://code.iconify.design/2/2.2.0/iconify.min.js"></script>

<script>!function(){for(var t=document.getElementsByClassName("onq-youtube-player"),e=0;e<t.length;e++)t[e].onclick=function(){var t=document.createElement("iframe"),e="true"==this.dataset.ssv?"1":"0",s="true"==this.dataset.spc?"1":"0",i="true"==this.dataset.sta?"1":"0",a="true"==this.dataset.dkc?"1":"0",r="true"==this.dataset.ecc?"1":"0",o="true"==this.dataset.eap?"1":"0";for(t.setAttribute("src","//www.youtube.com/embed/"+this.dataset.id+"?rel="+e+"&controls="+s+"&showinfo="+i+"&disablekb="+a+"&cc_load_policy="+r+"&autoplay="+o),t.setAttribute("frameborder","0"),t.setAttribute("id","youtube-iframe"),t.setAttribute("style","width: 100%; height: 100%; position: absolute; top: 0; left: 0;"),"true"==this.dataset.afs&&t.setAttribute("allowfullscreen","");this.firstChild;)this.removeChild(this.firstChild);this.appendChild(t)}}();</script>
    <script>



        document.addEventListener('DOMContentLoaded', () => {
            /** init gtm after 3500 seconds - this could be adjusted */
            setTimeout(initGTM, 3500);
        });
        document.addEventListener('scroll', initGTMOnEvent);
        document.addEventListener('mousemove', initGTMOnEvent);
        document.addEventListener('touchstart', initGTMOnEvent);

        function initGTMOnEvent (event) {
            initGTM();
            event.currentTarget.removeEventListener(event.type, initGTMOnEvent);
        }

        function initGTM () {
            if (window.gtmDidInit) {
                return false;
            }
            window.gtmDidInit = true;
            const script = document.createElement('script');
            script.type = 'text/javascript';
            script.async = true;
            script.onload = () => { dataLayer.push({ event: 'gtm.js', 'gtm.start': (new Date()).getTime(), 'gtm.uniqueEventId': 0 }); }
            script.src = 'https://www.googletagmanager.com/gtm.js?id=GTM-K2F34RS';

            document.head.appendChild(script);


        }
    </script>




    <script src="/assets/js/custom.js?221"></script>
        
        <noscript id="deferred-styles">
      <link rel="stylesheet" type="text/css" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.min.css"/>
    </noscript>

    <script>
		
		//$('#datetimepicker1').attr('readonly','readonly');

        $(".readmorehome").on("click", function(){
            var id=$(this).data('id');
            $(".homeinfo"+id).toggleClass('displayhomebottom');
        });

        // Add this script
        function deferIframe() {
            var iframeElem = document.getElementsByTagName('iframe');

            setTimeout(
                function() {
                    for ( var i = 0; i < iframeElem.length; i++ ) {

                        if(iframeElem[i].getAttribute('data-src')) {
                            iframeElem[i].setAttribute('src',iframeElem[i].getAttribute('data-src'));
                        }
                    }
                }, 2000);

        }
        window.onload = deferIframe;

       $("body").on("click",".saveposition", function(){
          
           var ua = navigator.userAgent.toLowerCase();
            var isAndroid = ua.indexOf("android") > -1; //&& ua.indexOf("mobile");
            if(isAndroid) {
                setTimeout(function(){
                window.scrollTo(0,0);
            }, 100);
            }
          
       });

      var loadDeferredStyles = function() {
        var addStylesNode = document.getElementById("deferred-styles");
        var replacement = document.createElement("div");
        replacement.innerHTML = addStylesNode.textContent;
        document.body.appendChild(replacement)
        addStylesNode.parentElement.removeChild(addStylesNode);
      };
      var raf = window.requestAnimationFrame || window.mozRequestAnimationFrame ||
          window.webkitRequestAnimationFrame || window.msRequestAnimationFrame;
      if (raf) raf(function() { window.setTimeout(loadDeferredStyles, 0); });
      else window.addEventListener('load', loadDeferredStyles);
    </script>

        
                <!-- Go to www.addthis.com/dashboard to customize your tools
<script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-4e10bf4216e05060"></script>-->
        
        <script>
            $( document ).ready(function() {
                event.preventDefault();
                var d = new Date();
                var n = d.getHours();
                
                $("#timepicker1").val(n+":00");
                $("#timepicker2").val(n+":00");
            });

            if (navigator.userAgent.match(/iPhone|iPad|iPod/i)) {
        $(document).on('opened', '.remodal', function (e) {

            $('.remodal-wrapper')
            .css({
                position: 'absolute',
                marginTop: $(window).scrollTop() + 'px',
                bottom: 'auto'
            });

            // Position backdrop absolute and make it span the entire page
            // 
            // Also dirty, but we need to tap into the backdrop after Boostrap 
            // positions it but before transitions finish.
            //
            setTimeout(function () {
                $('.remodal-overlay').css({
                    position: 'absolute',
                    top: 0,
                    left: 0,
                    width: '100%',
                    height: Math.max(
                    document.body.scrollHeight, document.documentElement.scrollHeight,
                    document.body.offsetHeight, document.documentElement.offsetHeight,
                    document.body.clientHeight, document.documentElement.clientHeight
                ) + 'px'
                });
            }, 0);


        });
    }
    
    var ua = navigator.userAgent.toLowerCase();
    var isAndroid = ua.indexOf("android") > -1; //&& ua.indexOf("mobile");
    if(isAndroid) {
        
        
       
       
    }
        </script>
        
        <script type="text/javascript">
            
            
             
                $("#datetimepicker1").on("blur",function(){
                    var from = $("#datetimepicker1").val().split(".");
                    var mindate = new Date(from[2], from[1] - 1, from[0]);
                    mindate.setDate(mindate.getDate() + 1);
                    
                    $( "#datetimepicker2" ).data("DateTimePicker").minDate(mindate);
                });
                
                
        </script>
        
        <script>
            $("#rezervisidugme").click(function(event) { // <- goes here !
                if (!$('#checkbox-04').is(':checked')){
                    event.preventDefault();
                    $("#error").show();
                } 
                
}           );
        $('#checkbox-04').on("change",function(){
            if (!$('#checkbox-04').is(':checked')){
                    $("#error").show();
                } 
            else{
                $("#error").hide();
            }
        });
            
            function parseDate(str) {
            var mdy = str.split('.');
            return new Date(mdy[1]+"/"+mdy[0]+"/"+mdy[2]);
            
            
        }

        function daydiff(first, second) {
           
            return Math.round((second-first)/(1000*60*60*24));
        }
            
    $("#mestopreuzimanja").on("change", function(){
        obracunaj();
    });
    $("#mestovracanja").on("change", function(){
        obracunaj();
    });
    function obracunaj() {

        $("#rezervisidugme").prop('disabled', true);
        var skupljidani = 0;
        var vreme1 = $("#timepicker1").val();
        var vreme2 = $("#timepicker2").val();

        var preuz = $("#mestopreuzimanja").val();
        var vrac = $("#mestovracanja").val();

        var data2 = '2038-01-19 ' + vreme1 + ':00';
        var d2 = new Date(data2.replace(' ', 'T'));
        var data1 = '2038-01-19 ' + vreme2 + ':00';
        var d1 = new Date(data1.replace(' ', 'T'));

        var sati = ((d1 - d2) / 1000) / (60 * 60);


        var ukdana = daydiff(parseDate($('#datetimepicker1').val()), parseDate($('#datetimepicker2').val()));

        if (sati > 2) {
            ukdana = ukdana + 1;
        }


        //Definisanje prvog cenovnika
        var prvidan = parseDate($("#datetimepicker1").val());
        var poslednjidan = parseDate($("#datetimepicker2").val());

        // var p_1cet = parseDate("07.04.2023");
        // var p_2cet = parseDate("10.04.2023");
        //
		// var dd_1cet=parseDate("14.04.2023");
        // var dd_2cet=parseDate("17.04.2023");
		//
        // //var prvidanakcije = parseDate("15.07.2023");
        // //var poslednjidanakcije = parseDate("10.08.2023");
        //
		// var ppp_1cet=parseDate("15.07.2023");
        // var ppp_2cet=parseDate("10.08.2023");
		
        var d_1cet=parseDate("15.07.2024");
        var d_2cet=parseDate("10.08.2024");



        if(d_1cet<poslednjidan && d_2cet>=poslednjidan ){
                if(d_1cet>=prvidan){
                    skupljidani=daydiff(d_1cet,poslednjidan);
                }
                else{
                    skupljidani=daydiff(prvidan,poslednjidan);
                }
            }
            else if(d_1cet>=prvidan && d_2cet<=poslednjidan){
            skupljidani=daydiff(d_1cet,d_2cet);
            }
            else if(prvidan>d_1cet && poslednjidan>d_2cet && prvidan<=d_2cet){
            skupljidani=daydiff(prvidan,d_2cet);
            }
            else if(prvidan>d_2cet){
            skupljidani=0;
            }


        

        // if (p_1cet < poslednjidan && p_2cet >= poslednjidan) {
        //      if (p_1cet >= prvidan) {
        //          skupljidani = daydiff(p_1cet, poslednjidan);
        //      } else {
        //         skupljidani = daydiff(prvidan, poslednjidan);
        //      }
        //  }
        //  else if (p_1cet >= prvidan && p_2cet <= poslednjidan) {
        //      skupljidani = daydiff(p_1cet, p_2cet);
        //  }
        //  else if (prvidan > p_1cet && poslednjidan > p_2cet && prvidan <= p_2cet) {
        //      skupljidani = daydiff(prvidan, p_2cet);
        //  }
        //  else if (prvidan > p_2cet) {
        //      skupljidani = 0;
        //  }
		

		
			// if (dd_1cet < poslednjidan && dd_2cet >= poslednjidan) {
         //     if (dd_1cet >= prvidan) {
         //         skupljidani = daydiff(dd_1cet, poslednjidan);
         //     } else {
         //        skupljidani = daydiff(prvidan, poslednjidan);
         //     }
         // }
         // else if (dd_1cet >= prvidan && dd_2cet <= poslednjidan) {
         //     skupljidani = daydiff(dd_1cet, dd_2cet);
         // }
         // else if (prvidan > dd_1cet && poslednjidan > dd_2cet && prvidan <= dd_2cet) {
         //     skupljidani = daydiff(prvidan, dd_2cet);
         // }
         // else if (prvidan > dd_2cet) {
         //     skupljidani = 0;
         // }

		
			// if (ppp_1cet < poslednjidan && ppp_2cet >= poslednjidan) {
         //     if (ppp_1cet >= prvidan) {
         //         skupljidani = daydiff(ppp_1cet, poslednjidan);
         //     } else {
         //        skupljidani = daydiff(prvidan, poslednjidan);
         //     }
         // }
         // else if (ppp_1cet >= prvidan && ppp_2cet <= poslednjidan) {
         //     skupljidani = daydiff(ppp_1cet, ppp_2cet);
         // }
         // else if (prvidan > ppp_1cet && poslednjidan > ppp_2cet && prvidan <= ppp_2cet) {
         //     skupljidani = daydiff(prvidan, ppp_2cet);
         // }
         // else if (prvidan > ppp_2cet) {
         //     skupljidani = 0;
         // }


        var jeftinidani = ukdana - skupljidani;
        //alert("Ukupno dana:"+ukdana+". Skupljih dana:"+skupljidani+". Jeftiniji dani:"+jeftinidani);


        //definisanje treceg cenovnika
        var najjeftiniji = 0;
        var p_1jef=parseDate("08.01.2024");
        var p_2jef=parseDate("28.03.2024");

        var d_1jef=parseDate("01.11.2024");
        var d_2jef=parseDate("22.12.2024");

         if(d_1jef<poslednjidan && d_2jef>=poslednjidan ){
            if(d_1jef>=prvidan){
            najjeftiniji=daydiff(d_1jef,poslednjidan);
            }
            else{
            najjeftiniji=daydiff(prvidan,poslednjidan);
            }
        }
        else if(d_1jef>=prvidan && d_2jef<=poslednjidan){
            najjeftiniji=daydiff(d_1jef,d_2jef);
        }
        else if(prvidan>d_1jef && poslednjidan>d_2jef && prvidan<=d_2jef){
            najjeftiniji=daydiff(prvidan,d_2jef);
        }
        else if(prvidan>d_2jef){
            najjeftiniji=0;
        }

        else if(p_1jef<poslednjidan && p_2jef>=poslednjidan ){
            if(p_1jef>=prvidan){
            najjeftiniji=daydiff(p_1jef,poslednjidan);
            }
            else{
            najjeftiniji=daydiff(prvidan,poslednjidan);

            }

        }
        else if(p_1jef>=prvidan && p_2jef<=poslednjidan){
             najjeftiniji+=daydiff(p_1jef,p_2jef);
        }
        else if(prvidan>p_1jef && poslednjidan>p_2jef && prvidan<=p_2jef){
            najjeftiniji=daydiff(prvidan,p_2jef);
        }
        else if(prvidan>p_2jef){
            najjeftiniji=0;
        }


        //definisanje cetvrtog cenovnika
        var cetvrti = 0;
        var p_1jefc=parseDate("02.04.2024");
        var p_2jefc=parseDate("29.04.2024");
        var d_1jefc = parseDate("06.05.2024");
        var d_2jefc = parseDate("15.06.2024");

        // var p_1jefc = parseDate("07.09.2022");
        // var p_2jefc = parseDate("19.12.2022");

        var z_1jefc = parseDate("01.09.2024");
        var z_2jefc = parseDate("31.10.2024");

        if (d_1jefc < poslednjidan && d_2jefc >= poslednjidan) {
            //console.log('OVdeee');
            if (d_1jefc >= prvidan) {
                cetvrti = daydiff(d_1jefc, poslednjidan);
            } else {
                cetvrti = daydiff(prvidan, poslednjidan);
            }
        } else if (d_1jefc >= prvidan && d_2jefc <= poslednjidan) {
            cetvrti = daydiff(d_1jefc,d_2jefc);
            //console.log(ukdana+"Razlika"+cetvrti);
        } else if (prvidan > d_1jefc && poslednjidan > d_2jefc && prvidan <= d_2jefc) {
            //console.log('OVdeeeeeeeeee');
            cetvrti = daydiff(prvidan, d_2jefc);
        }


        if (p_1jefc < poslednjidan && p_2jefc >= poslednjidan) {
            if (p_1jefc >= prvidan) {
                cetvrti += daydiff(p_1jefc, poslednjidan);
            } else {
                cetvrti += daydiff(prvidan, poslednjidan);

            }

        }
        else if (p_1jefc >= prvidan && p_2jefc <= poslednjidan) {
            cetvrti += daydiff(p_1jefc, p_2jefc);
        } else if (prvidan > p_1jefc && poslednjidan > p_2jefc && prvidan <= p_2jefc) {
            cetvrti = daydiff(prvidan, p_2jefc);
        }

            if(z_1jefc<poslednjidan && z_2jefc>=poslednjidan ){
                if(z_1jefc>=prvidan){
                    cetvrti+=daydiff(z_1jefc,poslednjidan);
                }
                else{
                    cetvrti+=daydiff(prvidan,poslednjidan);

                }

            }
            else if(z_1jefc>=prvidan && z_2jefc<=poslednjidan){
                cetvrti+=daydiff(z_1jefc,z_2jefc);
            }
            else if(prvidan>z_1jefc && poslednjidan>z_2jefc && prvidan<=z_2jefc){
                cetvrti+=daydiff(prvidan,z_2jefc);
            }




        //console.log(cetvrti);



               //console.log(jeftinidani+'-'+najjeftiniji+'-'+skupljidani+'-'+cetvrti);
               jeftinidani=jeftinidani-najjeftiniji-cetvrti;
               //console.log(jeftinidani+'-'+najjeftiniji+'-'+skupljidani+'-'+cetvrti);
               
             
               
               var id=$( "#carlist" ).val();
               
               var selected = "";
                $('#wishes input:checked').each(function() {
                    if(selected=="")
                    {
                        selected=$(this).val();
                    }
                    else{
                        selected=selected+","+$(this).val();
                    }
                });
                
                //console.log(jeftinidani+'-'+najjeftiniji+'-'+skupljidani+'-'+cetvrti);
               
               //alert(cetvrti);
               
                         $.ajax({
                             url: "/ajax/izracunaj.php",
                             type: "POST",
                             data: ({ukdana: ukdana,skupljidani: skupljidani, jeftinidani:jeftinidani,najjeftiniji:najjeftiniji,cetvrti:cetvrti,id:id,selected:selected,preuz:preuz}),
                             success: function(result){
                                 var exr = result.split('|');
                                 var uk=parseInt(exr[0])+parseInt(exr[1]);
                                 var dodatno=0;
                                 
                                 if(preuz!=vrac){
                                    if(preuz=="Aerodrom Beograd"){
                                        if(vrac=="Aerodrom Nis"){
                                            dodatno=85;
                                        }
                                        else if(vrac=="arandjelovac"){
                                            dodatno=45;
                                        }
                                        else if(vrac=="Kraljevo"){
                                            dodatno=75;
                                        }
                                    }
                                    if(preuz=="Aerodrom Nis"){
                                        if(vrac=="Aerodrom Beograd"){
                                            dodatno=85;
                                        }
                                        else if(vrac=="arandjelovac"){
                                            dodatno=85;
                                        }
                                        else if(vrac=="Kraljevo"){
                                            dodatno=85;
                                        }
                                    }
                                    if(preuz=="Arandjelovac"){
                                        if(vrac=="Aerodrom Beograd"){
                                            dodatno=45;
                                        }
                                        else if(vrac=="Aerodrom Nis"){
                                            dodatno=85;
                                        }
                                        else if(vrac=="Kraljevo"){
                                            dodatno=30;
                                        }
                                    }
                                    if(preuz=="Kraljevo"){
                                        if(vrac=="Aerodrom Beograd"){
                                            dodatno=75;
                                        }
                                        else if(vrac=="Aerodrom Nis"){
                                            dodatno=85;
                                        }
                                        else if(vrac=="arandjelovac"){
                                            dodatno=30;
                                        }
                                    }
                                 }
                                 
                                
                                 var dodatnopreuz="";
                                 if(dodatno!=0){
                                     dodatnopreuz="<h6><?=$xml->dodatnopreuz->$gllang;?>:"+dodatno+"€</h6>";
                                     uk=uk+dodatno;
                                 }
                                 var upcena=parseInt((parseInt(exr[0])*0.2)+parseInt(exr[0]));
                                 

                                 $("#ukcena").html("<h6><?=$xml->ukupnododaci->$gllang;?>:"+exr[1]+"€</h6><h6><?=$xml->ukupnovozilo->$gllang;?>: <span style='text-decoration: line-through;color: red;'>"+upcena+"€</span><br>"+exr[0]+"€</h6>"+dodatnopreuz+"<h4><?=$xml->ukupno->$gllang;?>:"+uk+"€</h4><br><h6><?=$xml->deposite->$gllang;?>:"+exr[2]+"€ <span style='font-size:13px; font-weight:300'><?=$xml->depositeinfovalute->$gllang;?></span></h6><div style='background:whitesmoke; padding:10px; margin-bottom: 10px;'><h6><i class='fa fa-percent' style='color:green'></i> <?=$xml->najboljacena->$gllang;?></h6><p><?=$xml->najboljacenainfo->$gllang;?></p></div><span style='font-size: 13px!important;'><?=$xml->ponuda->$gllang;?></span>");
                                $("#rezervisidugme").prop('disabled', false);
								 
								 localStorage.setItem('ukupnacena',"<h6><?=$xml->ukupnododaci->$gllang;?>:"+exr[1]+"€</h6><h6><?=$xml->ukupnovozilo->$gllang;?>: <span style='text-decoration: line-through;color: red;'>"+upcena+"€</span><br>"+exr[0]+"€</h6>"+dodatnopreuz+"<h4><?=$xml->ukupno->$gllang;?>:"+uk+"€</h4><br><h6><?=$xml->deposite->$gllang;?>:"+exr[2]+"€ <span style='font-size:13px; font-weight:300'><?=$xml->depositeinfovalute->$gllang;?></span></h6><div style='background:whitesmoke; padding:10px; margin-bottom: 10px;'><h6><i class='fa fa-percent' style='color:green'></i> <?=$xml->najboljacena->$gllang;?></h6><p><?=$xml->najboljacenainfo->$gllang;?></p></div><span style='font-size: 13px!important;'><?=$xml->ponuda->$gllang;?></span>");	
								

	}
							 
                            });
                        
              
            }
            
            $(".datetimepicker").on("blur",function(){
                if($("#datetimepicker1").val()!="" && $("#datetimepicker2").val()!="")
                obracunaj();
            });
            
            $("#carlist").on("change",function(){
                if($("#datetimepicker1").val()!="" && $("#datetimepicker2").val()!="")
                obracunaj();
                if($(this).val()==19)
                    <?php if($gllang=="sr"):?>
                $("#dodatniinfo").html('<p>Sa cenom do 7 dana kilometraža je ograničena na 300km dnevno<br><br></p>');
                <?php else:?>
                    $("#dodatniinfo").html('<p>With a price of up to 7 days, the mileage is limited to 300km per day<br><br></p>');
                <?php endif;?>
                else{
                  $("#dodatniinfo").html('');  
                }
            });
            
            $(".dodaci").on("click",function(){
                if($("#datetimepicker1").val()!="" && $("#datetimepicker2").val()!="")
				
                obracunaj();
            });
            $("#timepicker1").on("blur",function(){
                if($("#datetimepicker1").val()!="" && $("#datetimepicker2").val()!="")
                obracunaj();
            });
            $("#timepicker2").on("blur",function(){
                if($("#datetimepicker1").val()!="" && $("#datetimepicker2").val()!="")
                obracunaj();
            });
			
        </script>
        
        <script>
            $(".rezervacija").on('click',function(){
               var id=$(this).data('idcar');
               
			   $("option:selected").removeAttr("selected");
               var optionValue  = id;
               $("#carlist").val(optionValue)
                .find("option[value=" + optionValue +"]").attr('selected', true);
                obracunaj();
            });
            
            $('img:not([alt])').each(
            function(){
                var url=$(this).attr('src'); 
                var result = url.split('---');
                var result2= result[0].split('/');
                $(this).attr('alt', "Rent a car Beograd - "+result2[3].replace("_"," "));
            });
            
            $('img:not([title])').each(
            function(){
                var url=$(this).attr('src'); 
                var result = url.split('---');
                var result2= result[0].split('/');
                $(this).attr('title', "Rent a car Beograd, aerodrom Beograd - renta car - "+result2[3].replace("_"," "));
            });
            
            $('a:not([title])').each(
            function(){
                var title=$(this).text();
                $(this).attr('title', title);
            });
			
			
	
   

        </script>
	


</body>

</html>