<?php
session_start();
$site = "https://www.rentacarSarajevo.com/";

function sanitize_output($buffer) {
    
    require_once('min/lib/Minify/HTML.php');
    require_once('min/lib/Minify/CSS.php');
    require_once('min/lib/JSMin.php');
    $buffer = Minify_HTML::minify($buffer, array(
        'cssMinifier' => array('Minify_CSS', 'minify'),
        'jsMinifier' => array('JSMin', 'minify')
    ));
    
    $find=array('href="/sr/"',"viber%3A//chat?number","/sr/page/home","Ä","Ä‘","Ä‡","Å¡","Å¾","Ä†","Å½",'href="/sr/"','avaco','Avaco');
    $replace=array('href="/"',"viber://chat?number","/","č","đ","ć","š","ž","Ć","Ž",'href="/"','AR','AR');
    
    return str_replace($find,$replace,$buffer);
}
ob_start('sanitize_output');

?>
<?php
include 'class/classes.php';
$url_params = urldecode($_SERVER["REQUEST_URI"]);

if($base != "/")
    $url_params = explode("/",$url_params);

//Load LanguageXML
    $xml= simplexml_load_file("languages/arrent.xml") or die("XML not found");


$lang = $url_params[1];
$page = $url_params[2];



$pages=array("unser-fahrzeug","login","home","vozni-park","page","lokacije","blog-list","blog","our-vehicle","locations","car-rental","vozilo","dugorocni-najam-vozila-za-firme");

 $actual_link = "https://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
if ($actual_link==$site.'/index.php' || $actual_link==$site.'/index.html' || $actual_link==$site.'/index.html/' || $actual_link==$site.'/sr/index.html/' || $actual_link==$site.'/sr/index.php/') {
    $actual_link= $site;
    header("HTTP/1.1 301 Moved Permanently"); 
        header("Location: $actual_link"); 
        exit();
}

//redirect zombie queries
if($page!=""){
    if (!in_array($page, $pages)) {
         header('HTTP/1.1 404 Not Found');
         include '404.php';
         exit();
    }
}

if($url_params[3]=="404"){
    header('HTTP/1.1 404 Not Found');
}


if ((strpos($actual_link, 'index.php') !== false)) {
    $actual_link= "$site/".$lang."/";
    header("Location: $actual_link", true, 301);
}
    
    if($page=="home" || $url_params[3]=="home"){
        header("Location: $site/".$lang."/", true, 301);
    }

if($url_params[1]=="hr" && $url_params[2]==""){
    header("Location: $site/", true, 301);
}

if($url_params[1]=="sr" && $url_params[2]==""){
    header("Location: $site/", true, 301);
}


        $db = new DBConfig();
        $db -> config();
        $db -> conn();
        $db2 = new DBConfig();
        $db2 -> config();
        $db2 -> conn();
         $db3 = new DBConfig();
        $db3 -> config();
        $db3 -> conn();
    include'class/podesavanja.php';

    if(isset($lang))
        $gllang=$lang;
    else
        $gllang='sr';
    
    if($lang==""){
       $gllang='sr';
    }


    $link="page.link_".$gllang;
    if($page!="" && $page!="index")
        $where=" WHERE ".$link."='".$url_params[3]."'";
  
    else
        $where=" WHERE page.link_$gllang='home'";
    
    if($page=="home" || $page=="" || $page=="index")
        $where=" WHERE page.link_$gllang='home'";

    //Definisanje jezika za izvlacenje iz baze
    $metakey="key_".$gllang;
    $metadesc="metadesc_".$gllang;
    $metatitle="title_".$gllang;
    $naziv="naziv_".$gllang;
    $opis="opis_".$gllang;
    
    
    
    if($page=="page" || $page=="home" || $page==""){
    //Izvlacenje meta tagova
    $query="SELECT page.".$metakey.", page.".$metadesc.",page.".$metatitle.", page.".$naziv.", page.".$opis." FROM page ".$where;

    $db->queryDB($query);
    if($db->numrowDB()>0){
    $row=$db -> selectDB();
   
    //Definisanje meta tagova
    $title=($row[$metatitle]!="" ? $row[$metatitle] : $row[$naziv]." - ".$sitename);
    $desc=($row[$metadesc]!="" ? $row[$metadesc] : substr(strip_tags($row[$opis]),0,150));
    $key=($row[$metakey]!="" ? $row[$metakey] : '');

    if($page==""){
       if($gllang=="en"){
           $title="AR Rent a Car Belgrade | Airport Belgrade Nikola tesla";
           $desc="AR Rent a Car Belgrade, the largest selection of vehicles for rent in one place. Rent a car Belgrade airport is just one click away from you, with great prices.";
           $key=($row[$metakey]!="" ? $row[$metakey] : '');
       }
        if($gllang=="de"){
            $title="AR Rent a Car Sarajevo";
            //$desc="AR rent a car Zagreb, the largest offer of vehicles for rent in one place. Rent a car Zagreb airport one click away from you, great prices.";
            $key=($row[$metakey]!="" ? $row[$metakey] : '');
        }
    }
		
		if($page==''){
		 $h2="Rent a car Sarajevo, velik izbor vozila i povoljne cene - AR rent a car aerodrom Sarajevo.";}
    
    }
    else{
      
    }

    }
    else{

        if($page=="lokacije"){
        $title="Kontakt - AR rent a car Sarajevo";
        $desc="Kontaktirajte nas za sva pitanja o našim uslugama. Dostupni smo putem telefona, e-maila ili kontakt forme.";
    }
    
     if($page=="locations"){
        $title="Contact - AR rent a car Sarajevo";
        $desc="Contact us for any questions about our services. We are available by phone, e-mail or contact form.";
    }
     if($page=="vozni-park"){
        $title="Vozni park – Rent a car Sarajevo";
        $desc="Pogledajte naš vozni park! U ponudi imamo održavana vozila vrhunskog kvaliteta i sigurnosti.";
    }

    if($page=="our-vehicle"){
        $title="Vehicle fleet - Rent a car Sarajevo";
        $desc="Check out our fleet! We offer maintained vehicles of top quality and safety";
    }

    if($page=="blog-list"){
        if($gllang=="sr"){
        $title="Blog - AR rent a car Sarajevo: Savjeti i Informacije";
        $desc="Posjetite naš blog za savjete, vijesti i korisne informacije o rent a car uslugama u Sarajevu. Otkrijte inspiraciju za svoja putovanja!";
        }
        else{
           $title="Blog - AR rent a car Sarajevo: Tips and Information";
            $desc="Visit our blog for tips, news and useful information about rent a car services in Sarajevo. Discover inspiration for your travels!";
        }
    }

        
    if($page=="vozilo" || $page=="car-rental"){
		
        $id=$url_params[4];
        $query="SELECT * FROM cars WHERE id=$id";
        $db->queryDB($query);
        if($db->numrowDB()>0){
        $row=$db->selectDB();
        $title="title_".$gllang;
        $opis="metadesc_".$gllang; 
        if($gllang=="sr"){
            $title=($row[$title]!="" ? substr(strip_tags($row[$title]),0,255) : "Iznajmljivanje vozila:".$row['naziv']);
            $desc=($row[$opis]!="" ? substr(strip_tags($row[$opis]),0,255) : "Detalji za vozilo:".$row['naziv']);
        }
        else{
            $title=($row[$title]!="" ? substr(strip_tags($row[$title]),0,255) : "Iznajmljivanje vozila:".$row['naziv']);
            $desc=($row[$opis]!="" ? substr(strip_tags($row[$opis]),0,255) : "Details for vehicle:".$row['naziv']);
        }
        }
        else{
              header('HTTP/1.1 404 Not Found');

                include '404.php';
                exit();
        }
    }
    if($page=="prodaja" || $page=="car-rental"){

            $id=$url_params[4];
            $query="SELECT * FROM cars WHERE id=$id";
            $db->queryDB($query);
            if($db->numrowDB()>0){
                $row=$db->selectDB();
                $opis="opis_".$gllang;
                if($gllang=="sr"){
                    $title="Prodaja vozila - ".$row['naziv']." - AR rent a car Sarajevo";
                    $desc=($row[$opis]!="" ? substr(strip_tags($row[$opis]),0,255) : "Detalji za vozilo:".$row['naziv']);
                }
            }
            else{
                header('HTTP/1.1 404 Not Found');

                include '404.php';
                exit();
            }
        }
    $query="SELECT * FROM blog WHERE link_$gllang='".$url_params[3]."'";
   
    $db->queryDB($query);
    if($db->numrowDB()>0){
       $row=$db -> selectDB(); 
    $title=($row[$metatitle]!="" ? $row[$metatitle] : $row[$naziv])." - AR rent a car Sarajevo aerodrom";
    $desc=($row[$metadesc]!="" ? $row[$metadesc] : substr(strip_tags($row[$opis]),0,150));
    $key=($row[$metakey]!="" ? $row[$metakey] : '');
		$h2="Sve najnovije informacije vezane za rent a car Sarajevo možete pronaći ovde kod nas.";
    }


    
    }

    //de
    if($page=="unser-fahrzeug"){

        $title="Unser Fahrzeug - AR rent a car Belgrad";
        $desc="Überprüfen Sie alle Fahrzeuge aus unserem Angebot und wählen Sie einige für Sie aus.";

    }

   
    //OG images
    if($page=="" || $page=="home"){
        $ogimage=$site."/assets/img/AR-logo.jpg";
    }
    else if($page=="vozilo"){
        $id=$url_params[4];
        $query="SELECT * FROM cars WHERE id=$id";
        $db->queryDB($query);
        $row=$db->selectDB();

        $sl= get_first_image($row['slike']);
        
        $ogimage=$site.str_replace('"','',safeecho($sl));
    }
    else{
        $ogimage=$site."/assets/img/AR-logo.jpg";
    }
  
    
    if ($gllang!="sr" && $gllang!="en" && $gllang!="de") {
    $actual_link= $site;
    header("HTTP/1.1 301 Moved Permanently"); 
        header("Location: $actual_link"); 
        exit();
}


 
?>
<!DOCTYPE html>
<?php
if($gllang=="sr"){
    ?>
<html lang="sr">
<?php
}
else{
?>
<html lang="<?=$gllang;?>">
<?php
}
?>
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="description" content="<?=$desc;?>">
    <?php

    if($gllang=="ru"){
        $gllang="de";
    }

    if($page==""):
    ?>
        <meta name="keywords" content="rent a car, rent a car Sarajevo, rent a car Sarajevo aerodrom, povoljne cene, najam auta, brza realizacija, povoljni najmovi, niske cene, najjeftiniji rent a car, poslovna ponuda, kratkoročni, dugoročni, leasing ili kredit, rent a car Aerodrom Sarajevo, rent a car Sarajevo cene, najam kombi vozila Sarajevo"/>
<?php endif;?>

<!--        <meta name="robots" content="index, follow" />-->
        <meta name="distribution" content="global"/>
        
        <meta name="robots" content="noindex">
        
        <meta property="og:title" content="<?=$title;?>" />
        <meta property="og:description" content="<?=$desc;?>" />
        <meta property="og:type" content="website" />
        <meta property="og:url" content="<?=str_replace(":443/","/",full_url());?>" />
        <meta property="og:image" content="<?=$ogimage;?>" />

        
    <link rel="apple-touch-icon" sizes="180x180" href="/favicon.jpg">
    <link rel="icon" type="image/png" sizes="32x32" href="/favicon.jpg">
    <link rel="icon" type="image/png" sizes="16x16" href="/favicon.jpg">
    <link rel="manifest" href="/site.webmanifest">
	<title><?=$title;?></title>
    <meta name="google-site-verification" content="Zxx7rUEk1_CMc6y0hAU7E-ipVNtChYNnUBVcVcO4_J8" />

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="/assets/css/bootstrap-grid.min.css">
    <link rel="stylesheet" href="/assets/css/bootstrap-reboot.min.css">
    <link rel="stylesheet" href="/assets/css/style.css">
    <link rel="stylesheet" href="/assets/css/home.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.css">

    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-B12FPR32S6"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', 'G-B12FPR32S6');
    </script>

</head>

<body class="page__home">
	
	<script type="application/ld+json">
            {
                "@context": "https://schema.org",
                "@type": "ProfessionalService",
                "description": "<?=$desc;?>",
                "name": "AR rent a car Sarajevo",
                "image": "<?=$site;?>/assets/img/rentacar-sarajevo.png",
                "url": "<?=$site;?>",
                "telephone": "+38762222012",
                "priceRange": "15-70€/day",
                "sameAs": [
                  "https://www.instagram.com/ARrentacar/"
                ],
                "address": {
                    "@type": "PostalAddress",
                    "streetAddress": "Sarajevo",
                    "addressLocality": "Sarajevo",
                    "postalCode": "71000",
                      "addressCountry": "BA"
                }
            }
        </script>



    <header>
        <div class="inobar">
            <div class="container">
                <div class="d-flex justify-content-between ">
                    <!-- on mobile -->
                    <div class="d-block d-sm-none">
                        <button id="openmobilenav">
                            <img src="/assets/img/icons/svgs/solid/bars.svg" width="22" height="25"  alt="Rent a car Navigacija" title="Otvorite rent a car navigaciju"/>
                        </button>
                    </div>
                    <!-- end of on mobile -->
                    <div class="inolist">
                        <ul class="list-info">
                            <li class="first-li">
                                <img src="/assets/img/icons/email.png" alt="Email">
                                <a href="mailto:ar@rentacarsarajevo.com">ar@rentacarsarajevo.com</a>
                            </li>
                            <li>
                                <img src="/assets/img/icons/telephone.png" alt="Telefon">
                                <a href="tel:+38762222012">+387 62 222 012</a>
                            </li>
                        </ul>
                    </div>



                    <ul class="inolist right">
                            <li class="flag">
                                <a href="/"><img src="/assets/img/icons/bosnia-and-herzegovina.png"  width="16" height="16"  alt="Rent a car Sarajevo" title="Rentacar Sarajevo"/> <?=$xml->srpski->$gllang;?></a>
                            </li>
                            <li class="flag">
                                <a href="/en/"><img src="/assets/img/icons/united-kingdom.png"  width="16" height="16" alt="Rent a car Sarajevo" title="Rent a car Sarajevo"/> English</a>
                            </li>
                    </ul>


                </div>
            </div>
        </div>

        <div class="mainheader">
            <div class="container">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="logo">
                        <?php
                        $dodataklogo = "";
                        if($gllang=="sr"){
                            $dodataklogo="";
                        }
                        else{
                            $dodataklogo=$gllang."/";
                        }
                        ?>
                        <a href="/<?=$dodataklogo;?>">
                            <img src="/assets/img/rentacar-sarajevo.png" <?php if(is_mobile()):?>width="87.5" height="35"<?php else:?>width="224" height="auto"<?php endif;?> class="logo" alt="<?=$xml->logoname->$gllang;?>"/>
                        </a>
                    </div>
                    <div class="nav" id="mainnav">
                        <ul>
                            <li><a href="/<?=$gllang;?>/<?=$xml->ln_voznipark->$gllang;?>/" data-hover="<?=$xml->cars->$gllang;?>"><?=$xml->cars->$gllang;?></a></li>

                            <?php
                            $query="SELECT * FROM menu WHERE id_master=0 AND red<100 ORDER BY red";
                            $db->queryDB($query);
                            $naziv="naziv_".$gllang;
                            $link="link_".$gllang;

                            while($row=$db -> selectDB()):
                                $dopusteno=1;
//                                if($gllang=="sr"){
//                                    $dopusteno=1;
//                                }
//                                if($gllang=="en"){
//                                    $dopusteno=1;
//                                    if($row['id']=="123"){
//                                        $dopusteno=0;
//                                    }
//                                }
//                                if($gllang=="de"){
//                                    $dopusteno=1;
//                                    if($row['id']=="123"  || $row['id']=="124"){
//                                        $dopusteno=0;
//                                    }
//                                }
                                if($dopusteno==1){
                                $br=0;
                                //echo $row['id']."<br>";
                                $query3="SELECT * FROM page WHERE id=".$row['id_page'];
                                $db3->queryDB($query3);
                                $row3=$db3 -> selectDB();
                                ?>

                                <?php
                                $query2="SELECT menu.naziv_sr, menu.naziv_en, page.link_sr, page.link_en FROM menu INNER JOIN page ON menu.id_page=page.id WHERE menu.id_master=".$row['id']." AND red<100 ORDER BY menu.red";
                                $db2->queryDB($query2);
                                $naziv2="naziv_".$gllang;
                                $link2="link_".$gllang;
                                if($db2->numrowDB()>0):
                                    ?>
                                    <li><a href="/<?=$gllang;?>/page/<?=$row[$link];?>/"><?=$row[$naziv];?> <i class="icon-arrow-down-sign-to-navigate"></i></a>
                                        <ul class="sub-menu dropdown-menu">
                                            <?php
                                            while($row2=$db2 -> selectDB()):
                                                ?>
                                                <li><a href="/<?=$gllang;?>/page/<?=$row2[$link];?>/"><?=$row2[$naziv];?></a></li>
                                            <?php
                                            endwhile;
                                            ?>

                                        </ul>
                                    </li>
                                <?php else:?>

                                    <li><a href="/<?=$gllang;?>/page/<?=$row3[$link];?>/"><?=$row[$naziv];?> </a></li>
                                <?php endif;?>
                            <?php
                                }
                            endwhile;?>
                            <?php
                            if($gllang=="sr"):
                            ?>
                                <li>
                                    <a href="/<?=$gllang;?>/blog-list/"><?=$xml->blog->$gllang;?>
                                    </a>
                                </li>
                                <li>
                                    <a href="/<?=$gllang;?>/<?=$xml->ln_location->$gllang;?>/" data-hover="<?=$xml->location->$gllang;?>"><?=$xml->location->$gllang;?>
                                    </a>
                                </li>

                            <?php endif;?>

                            <li><a href="#" class="open-modal" data-target="modal"><?=$xml->booknow->$gllang;?></a></li>



                        </ul>
                    </div>
                    <div class="contact">
                        <a href="tel:+38762222012" class="phone">+387 62 222 012</a>
                        <a href="viber://chat?number=+38762222012 " class="icon"><img src="/assets/img/icons/viber.png" alt="Ar - Rent a car Viber"/></a>
                        <a href="https://wa.me/+38762222012 " class="icon"><img src="/assets/img/icons/whatsapp.png" alt="Ar - Rent a car WhatsApp"/></a>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <?php

    if($page=="vozni-park" || $page=="our-vehicle" || $page=="unser-fahrzeug")
    {
        include "application/cars.php";
    }
    elseif($page=="locations" || $page=="lokacije" || $page=="локации"){
        include "application/location.php";
    }
    elseif($page=="vozilo" || $page=="car-rental"){
        include "application/iznajmljivanje-vozila.php";
    }
    elseif($page=="rent-a-car-nis"){
        include "application/rent-a-car-nis.php";
    }
    elseif($page=="polovna-vozila"){
        include "application/polovna-vozila.php";
    }
    elseif($page=="prodaja"){
        include "application/prodaja.php";
    }
    elseif($page==""){
        include "application/home.php";
    }
    else{
        include "application/".$page.".php";
    }
    ?>

    <footer class="site-footer">
        <section class="site-footer-top">
            <div class="container">
                <div class="row justify-content-between d-flex">
                    <div class="col-xs-12 col-sm-4">
                        <div class="top-info">
                            <strong><?=$xml->fastbook->$gllang;?></strong>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-4 justify-content-center">
                        <div class="top-info">
                            <strong><?=$xml->nocreditcards->$gllang;?></strong>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-4">
                        <div class="top-info">
                            <strong><?=$xml->locationonairport->$gllang;?></strong>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section class="box-elements">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-6 col-md-12 col-lg-3">
                        <figure class="footer-logo">
                            <div>
                                <a href="/"><img src="/assets/img/rentacar-sarajevo.png" alt="AR Rent a car Sarajevo"  loading="lazy"/></a><br>
                            </div>
                        </figure>
                    </div>
                    <div class="col-xs-12 col-sm-6 col-md-4 col-lg-3">
                        <p><strong><?=$xml->istaknutilinkovi->$gllang;?></strong></p>
                        <ul class="footer-list">

                            <?php
                            $query="SELECT * FROM menu WHERE id_master=0 AND red>=100 AND red<200 AND naziv_sr!='Home' ORDER BY red";
                            $db->queryDB($query);
                            $naziv="naziv_".$gllang;
                            $link="link_".$gllang;

                            while($row=$db -> selectDB()):
                                $br=0;
                                //echo $row['id']."<br>";
                                $query3="SELECT * FROM page WHERE id=".$row['id_page'];
                                $db3->queryDB($query3);
                                $row3=$db3 -> selectDB();

                                ?>

                                <?php
                                $query2="SELECT menu.naziv_sr, menu.naziv_en, page.link_sr, page.link_en FROM menu INNER JOIN page ON menu.id_page=page.id WHERE menu.id_master=".$row['id']." ORDER BY menu.red";
                                $db2->queryDB($query2);
                                $naziv2="naziv_".$gllang;
                                $link2="link_".$gllang;
                                if($db2->numrowDB()>0):

                                    ?>
                                    <li><a href="/<?=$gllang;?>/page/<?=$row[$link];?>/"><?=$row[$naziv];?> <i class="icon-arrow-down-sign-to-navigate"></i></a>
                                        <ul class="sub-menu dropdown-menu">
                                            <?php
                                            while($row2=$db2 -> selectDB()):
                                                ?>
                                                <li><a href="/<?=$gllang;?>/page/<?=$row2[$link];?>/"><?=$row2[$naziv];?></a></li>
                                            <?php
                                            endwhile;
                                            ?>
                                        </ul>
                                    </li>
                                <?php
                                else:?>

                                    <li><a href="/<?=$gllang;?>/page/<?=$row3[$link];?>/"><?=$row[$naziv];?></a></li>
                                <?php endif;?>
                            <?php endwhile;?>
                              </ul>
                    </div>
                    <div class="col-xs-12 col-sm-6 col-md-4 col-lg-3">
                        <p><strong><?=$xml->pogledajtejos->$gllang;?></strong></p>
                        <ul class="footer-list">
                                            <li><a href="https://www.arrentacar.rs/" target="_blank">AR Rent a car Beograd</a></li>
                                            <li><a href="https://www.rentacarbeograd.com/" target="_blank">Efex Rent a car Beograd</a></li>
                                            <li><a href="https://www.rentacarzagreb.com/" target="_blank">Efex rent a car Zagreb</a></li>
                            <li><a href="https://www.efexfleet.rs/" target="_blank">Mesečni najam vozila Efex Fleet</a></li>
                            <li><a href="https://www.aerodromparkingar.com/" target="_blank">Aerodrom parking Beograd</a></li>

                          </ul>
                    </div>
                    <div class="col-xs-12 col-sm-6 col-md-4 col-lg-3">
                        <div class="contact-info">
                            <ul class="footer-contant">
                                <li class="mb-2"><strong><?=$xml->contactinformations->$gllang;?>:</strong></li>
                                <li><a href="mailto:ar@rentacarsarajevo.com">ar@rentacarsarajevo.com</a></li>

                                    <li> <a href="tel:+38762222012">
                                            +387 62 222 012
                                        </a>
                                        <ul class="socila-footer">
                                            <li>
                                                <a href="https://wa.me/38762222012" class="belo strong-400">
                                                    <img src="/assets/img/icons/whatsapp.png" height="16" alt="Ar - Rent a car WhatsApp" loading="lazy"> WhatsApp
                                                </a>
                                            </li>
                                            <li>
                                                <a href="viber://chat?number=38762222012" class="belo strong-400">
                                                    <img src="/assets/img/icons/viber.png" height="16" alt="Ar - Rent a car Viber" loading="lazy"> Viber
                                                </a>
                                            </li>
                                        </ul>
                                    </li>

                            </ul>

                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section class="site-footer-copy">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-md-6">
                        <div class="copyright">&copy; <?=date("Y");?> All rights reserved -  <strong>AR Rent a car Sarajevo</strong></div>
                    </div>
                    <div class="col-xs-12 col-md-6" style="text-align: right;">
                        <a href="https://www.global-webmasters.com" target="_blank">Izrada web stranice</a> - Global Webmasters
                    </div>
                </div>
            </div>
        </section>

        <div class="modal-overlay">
            <div class="modal">
                <button class="close-modal">&times;</button>
                <div class="modal-content">
                    <form class="order-details-form" id="bookingForm" name="bookingform" method="post" action="/sendreservation.php" novalidate>
                        <input type="hidden" name="lang" value="<?=$gllang;?>">
                        <div class="inner-form" id="displayinfo">
                            <h3 class="font-black"><?=$xml->orderform->$gllang;?></h3>
                            <div class="row">
                                <div class="col-md-7">
                                    <h5>&nbsp;</h5>
                                    <div class="col-xl-6 form-group">
                                        <select name="car" id="carlist" class="calculate" required="">
                                            <?php
                                            $query="SELECT * FROM cars ORDER BY redosled";
                                            $db->queryDB($query);
                                            while($row=$db->selectDB()):
                                                ?>
                                                <option value="<?=$row['id'];?>"><?php if($gllang=='en'){echo $row['naziv_en'];} else if($gllang=='de'){echo $row['naziv_de'];} else {echo $row['naziv'];} ?></option>
                                            <?php endwhile;?>
                                        </select>
                                        <label class="form-label"><?=$xml->choosecar->$gllang;?>:</label>
                                    </div>

                                    <div class="col-xl-6 form-group">
                                        <select name="mestopreuzimanja" class="calculate" id="mestopreuzimanja">
                                            <option value="Aerodrom Sarajevo"><?=$xml->aerodrom->$gllang;?></option>
                                        </select>
                                        <label class="form-label"><?=$xml->mestopreuzimanja->$gllang;?>:</label>
                                    </div>

                                    <div class="col-xl-6 form-group">
                                        <select name="mestovracanja"  class="calculate" id="mestovracanja">
                                            <option value="Aerodrom Sarajevo"><?=$xml->aerodrom->$gllang;?></option>
                                        </select>
                                        <label class="form-label"><?=$xml->mestovracanja->$gllang;?>:</label>
                                    </div>

                                    <div class="row">
                                        <div class="col-xl-12 form-group">
                                            <label class="form-label"><?=$xml->datumpreuzimanja->$gllang;?>:</label>
<!--                                        <div class="col-md-6 form-group">-->
<!--                                            <input type="datetime-local" class="calculate" name="datumpreuzimanja"  id="datetimepicker1" min="--><?php //echo date('Y-m-d\TH:i'); ?><!--" required>-->
<!--                                            <label class="form-label">--><?php //=$xml->datumpreuzimanja->$gllang;?><!--*:</label>-->
<!--                                        </div>-->
<!---->
<!--                                        <div class="col-md-6 form-group">-->
<!--                                            <input type="datetime-local" class="calculate" name="datumvracanja"  id="datetimepicker2" min="--><?php //echo date('Y-m-d\TH:i'); ?><!--" required>-->
<!--                                            <label class="form-label">--><?php //=$xml->datumvracanja->$gllang;?><!--*:</label>-->
<!--                                        </div>-->
                                            <input type="text" class="calculate" id="daterangepicker" name="daterange" readonly value="01/01/2018 - 01/15/2018" />
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 col-xs-6 form-group">
                                            <input type="text" name="vremepreuzimanja" id="timepicker1" readonly="readonly" class="timepicker calculate saveposition valid" placeholder="<?=$xml->vremepreuzimanja->$gllang;?>">
                                            <label class="form-label"><?=(is_mobile() ? $xml->vremepreuzimanja->$gllang : $xml->vremepreuzimanja->$gllang);?>*:</label>
                                        </div>

                                        <div class="col-md-6 col-xs-6 form-group">
                                            <input type="text" name="vremevracanja" id="timepicker1" readonly="readonly" class="timepicker calculate saveposition valid" placeholder="<?=$xml->vremevracanja->$gllang;?>">
                                            <label class="form-label"><?=(is_mobile() ? $xml->vremevracanja->$gllang : $xml->vremevracanja->$gllang);?>:</label>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-5 included-box">
                                            <h6 class="font-black"><?=$xml->uracunato->$gllang;?></h6>
                                            <ul class='listincluded' style='font-weight:300;margin-bottom:5px;'><li><i class='fa fa-check-square-o' style='position: inherit;    color: green;'></i> <?=$xml->kasko->$gllang;?></li> <li><i class='fa fa-check-square-o' style='position: inherit;    color: green;'></i> <?=$xml->osiguranjeputnika->$gllang;?></li><li><i class='fa fa-check-square-o' style='position: inherit;    color: green;'></i> <?=$xml->neokilometraza->$gllang;?></li><li><i class='fa fa-check-square-o' style='position: inherit;    color: green;'></i> <?=$xml->porez->$gllang;?></li><li><i class='fa fa-check-square-o' style='position: inherit;    color: green;'></i> <?=$xml->oboprema->$gllang;?></li><li><i class='fa fa-check-square-o' style='position: inherit;    color: green;'></i> <?=$xml->sedistazadecu->$gllang;?></li><li><i class='fa fa-check-square-o' style='position: inherit;    color: green;'></i> <?=$xml->prterminal->$gllang;?></li><li><i class='fa fa-check-square-o' style='position: inherit;    color: green;'></i>  <?=$xml->freedatechange->$gllang;?></li></ul>
                                        </div>
                                        <div class="col-md-7">
                                            <div class="text-element checkbox-div">
                                                <div class="wishes" id="wishes">
                                                    <h6 class="font-black"><?=$xml->dodaci->$gllang;?>:</h6>
                                                    <div class="box-checkbox">
                                                        <input type="checkbox" name="dodaci[]" class="dodaci calculate" id="checkbox-07" value="fullosiguranje">
                                                        <label for="checkbox-07"><?=$xml->fullosiguranje->$gllang;?></label>
                                                    </div>

<!--                                                    <div class="box-checkbox">-->
<!--                                                        <input type="checkbox" name="dodaci[]" class="dodaci calculate" id="checkbox-07" value="premiumosiguranje">-->
<!--                                                        <label for="checkbox-07 smaller">--><?php //=$xml->premiumosiguranje->$gllang;?><!--</label>-->
<!--                                                    </div>-->

<!--                                                    <div class="box-checkbox">-->
<!--                                                        <input type="checkbox" name="dodaci[]" class="dodaci calculate" id="checkbox-05" value="gps">-->
<!--                                                        <label for="checkbox-05 smaller">--><?php //=$xml->gps->$gllang;?><!--</label>-->
<!--                                                    </div>-->

<!--                                                    <div class="box-checkbox">-->
<!--                                                        <input type="checkbox" name="dodaci[]" class="dodaci calculate" id="checkbox-06" value="wifi">-->
<!--                                                        <label for="checkbox-06 smaller">--><?php //=$xml->wifi->$gllang;?><!--</label>-->
<!--                                                    </div>-->

                                                    <div class="box-checkbox">
                                                        <input type="checkbox" name="dodaci[]" class="dodaci calculate" id="checkbox-booster" value="decijibooster">
                                                        <label for="checkbox-booster"><?=$xml->sedistazadecu->$gllang;?></label>
                                                    </div>

                                                    <div class="box-checkbox">
                                                        <input type="checkbox" name="dodaci[]" class="dodaci calculate" id="checkbox-sed" value="sedistazadecu1">
                                                        <label for="checkbox-sed"><?=$xml->sedistazadecu1->$gllang;?></label>
                                                    </div>

                                                    <div class="box-checkbox">
                                                        <input type="checkbox" name="dodaci[]" class="dodaci calculate" id="checkbox-sed1" value="sedistazadecu2">
                                                        <label for="checkbox-sed1"><?=$xml->sedistazadecu2->$gllang;?></label>
                                                    </div>

                                                    <div class="box-checkbox">
                                                        <input type="checkbox" name="dodaci[]" class="dodaci calculate" id="checkbox-sed2" value="sedistazadecu3">
                                                        <label for="checkbox-sed2"><?=$xml->sedistazadecu3->$gllang;?></label>
                                                    </div>

                                                    <div class="box-checkbox">
                                                        <input type="checkbox" name="dodaci[]" class="dodaci calculate" id="checkbox-vozac" value="dodatnivozac">
                                                        <label for="checkbox-vozac"><?=$xml->dodatnivozac->$gllang;?></label>
                                                    </div>

                                                    <div class="box-checkbox">
                                                        <input type="checkbox" name="dodaci[]" class="dodaci calculate" id="checkbox-zk" value="zelenikarton">
                                                        <label for="checkbox-zk"><?=$xml->zelenikarton->$gllang;?></label>
                                                    </div>

                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div id="ukcena"><span class="firstinfo">! <?=$xml->choosedates->$gllang;?></span></div>
                                    </div>

                                </div>
                                <div class="col-md-5">
                                    <h5><?=$xml->contactinformations->$gllang;?></h5>

                                    <div class="row">
                                        <div class="col-md-6 form-group">
                                            <input type="text" name="firstname" class="saveposition" id="firstname" required="">
                                            <label class="form-label"><?=$xml->name->$gllang;?> *:</label>
                                        </div>

                                        <div class="col-md-6 form-group">
                                            <input type="text" name="lastname" class="saveposition" id="lastname" required="">
                                            <label class="form-label"><?=$xml->lastname->$gllang;?> *:</label>
                                        </div>
                                    </div>
                                    <div class="col-xl-6 form-group">
                                        <input type="tel" name="phone" class="saveposition" id="phone" required="">
                                        <label class="form-label"><?=$xml->phone->$gllang;?> *:</label>
                                    </div>

                                    <div class="col-xl-6 form-group">
                                        <input type="email" name="email" class="saveposition" id="email" required="">
                                        <label class="form-label">E-mail *:</label>
                                    </div>


                                    <div class="row">
                                        <div class="col-md-6 form-group">
                                            <input type="text" name="datumrodjenja" id="datumrodjenja" required="">
                                            <label class="form-label"><?=(is_mobile() ? $xml->datumrodjenja->$gllang : $xml->datumrodjenja->$gllang);?>*:</label>
                                        </div>

                                        <div class="col-md-6 form-group">
                                            <input type="text" name="brleta" id="brleta">
                                            <label class="form-label"><?=(is_mobile() ? $xml->brletamobile->$gllang : $xml->brleta->$gllang);?>:</label>
                                        </div>
                                    </div>

                                    <div class="col-xl-6 form-group">
                                        <textarea name="specialreguests" id="comment" placeholder="<?=$xml->writecomment->$gllang;?>"></textarea>
                                    </div>


                                    <div class="text-element checkbox-div">
                                        <div class="wishes">
                                            <div class="box-checkbox">
                                                <input type="checkbox" name="uslovikoriscenja" id="checkbox-04" checked="" required="">
                                                <label for="checkbox-04"><?=$xml->iaccept->$gllang;?> <a href="<?=$xml->termslink->$gllang;?>" target="_blank" style="color:blue;"><?=$xml->terms->$gllang;?></a></label>
                                                <div id="error" style="display:none; color:red"><?=$xml->termserror->$gllang;?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="dodatniinfo"></div>
                                    <p><i class='fa fa-check-square-o' style='position: inherit;    color: green;'></i>✔️ <?=$xml->besplatnootkazivanje->$gllang;?><br>
                                        <i class='fa fa-check-square-o' style='position: inherit;    color: green;'></i>✔️ <?=$xml->placanjepripreuzimanju->$gllang;?>
                                    </p>
                                    <input type="hidden" id="recaptchaResponse-reservation" name="recaptchaResponse"/>
                                    <button type="submit" class="btn-info" id="rezervisidugme"><?=$xml->reserve->$gllang;?></button>
                                </div>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>

    </footer>
    <div class="footerlinks">
        <div class="col-xs-6 call" style="background: #d9b034;text-align: center; padding: 15px 10px;">
            <a href="tel:+38762222012" title="Pozovi nas">Pozovi nas</a>
         
        </div>
        <div class="col-xs-6 booking" style="background: black;text-align: center; padding: 15px 10px;">
            <button class="open-modal booking-btn" data-target="modal">Rezerviši</button>
        </div>

    </div>





    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

    <script src="/assets/js/style.js?1.2"></script>
    <script src="/assets/js/calculate.js"></script>

    <script src="//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.js"></script>

    <script>
        $(function() {
            function getNearestHalfHour() {
                var now = new Date();
                var minutes = now.getMinutes();
                var nearestMinutes = minutes < 15 ? 0 : (minutes < 45 ? 30 : 0);
                if (nearestMinutes === 0 && minutes >= 45) {
                    now.setHours(now.getHours() + 1);
                }
                now.setMinutes(nearestMinutes);
                return now;
            }

            $(".open-modal").on("click", function(){
                $('input[name="daterange"]').daterangepicker({
                    minDate: new Date(),
                    "opens": "center",
                    "drops": "auto",
                    timePicker: false,
                    timePickerIncrement: 15,
                    timePicker24Hour: true,
                    startDate: moment().startOf('hour'),
                    endDate: moment().startOf('hour').add(32, 'hour'),
                    locale: {
                        format: 'DD.MM.YYYY'
                    }
                }, function(start, end, label){
                    setTimeout(function(){
                        obracunaj();
                    },500);
                });

                var nearestTime = getNearestHalfHour();
                var formattedTime = nearestTime.getHours().toString().padStart(2, '0') + ':' + nearestTime.getMinutes().toString().padStart(2, '0');

                $('input.timepicker').timepicker({
                    timeFormat: 'HH:mm',
                    interval: 30,
                    defaultTime: formattedTime,
                    change: function(time) {
                        obracunaj();
                    }
                });
            });
        });
    </script>

</body>

</html>