<?php
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);
function CroppedThumbnail($imgSrc,$thumbnail_width,$thumbnail_height) { //$imgSrc is a FILE - Returns an image resource.
//getting the image dimensions
    $supported_image = array(
        'gif',
        'jpg',
        'jpeg',
        'png'
    );

    $ext = strtolower(pathinfo($imgSrc, PATHINFO_EXTENSION)); // Using strtolower to overcome case sensitive
    if (!in_array($ext, $supported_image)) {
        $imgSrc="image-not-found.png";
    }
    list($width_orig, $height_orig) = getimagesize($imgSrc);


    if(exif_imagetype($imgSrc)==IMAGETYPE_GIF || exif_imagetype($imgSrc)==IMAGETYPE_PNG){
        if(exif_imagetype($imgSrc)==IMAGETYPE_GIF){
            $myImage = imagecreatefromgif($imgSrc);
        }
        else{
            $myImage = imagecreatefrompng($imgSrc);
        }
    }
    else{
        $myImage = imagecreatefromjpeg($imgSrc);


    }

    $ratio_orig = $width_orig/$height_orig;

    if ($thumbnail_width/$thumbnail_height > $ratio_orig) {
        $new_height = $thumbnail_width/$ratio_orig;
        $new_width = $thumbnail_width;
    } else {
        $new_width = $thumbnail_height*$ratio_orig;
        $new_height = $thumbnail_height;
    }

    $x_mid = $new_width/2;  //horizontal middle
    $y_mid = $new_height/2; //vertical middle

    $process = imagecreatetruecolor(round($new_width), round($new_height));
    imagesavealpha($process, true);
    $colors = imagecolorallocatealpha($process, 0, 0, 0,127);
    // Make the background transparent
    imagefill($process, 0, 0, $colors);
    //imagecolortransparent($process, $colors);

    imagecopyresampled($process, $myImage, 0, 0, 0, 0, $new_width, $new_height, $width_orig, $height_orig);
    $thumb = imagecreatetruecolor($thumbnail_width, $thumbnail_height);

    imagesavealpha($thumb, true);
    $colors = imagecolorallocatealpha($thumb, 255, 255, 255,0);
    // Make the background transparent
    imagefill($thumb, 0, 0, $colors);

    imagecopyresampled($thumb, $process, 0, 0, ($x_mid-($thumbnail_width/2)), ($y_mid-($thumbnail_height/2)), $thumbnail_width, $thumbnail_height, $thumbnail_width, $thumbnail_height);

    imagedestroy($process);
    imagedestroy($myImage);
    return $thumb;
}

$checkcache=__DIR__."/cache/".str_replace("/","_",$_SERVER[REQUEST_URI]);
if (is_file($checkcache)) {
    //check cache time
    if (@filemtime($checkcache) > strtotime('-10 days')) {
        header('Cache-Control: max-age=31449600, public');
        header('Content-type: image/webp');
        readfile($checkcache);
        exit();
    }
    else{
        showImage();
    }
}
else{
    showImage();
}
function showImage(){
include '../class/classes.php';
$db = new DBConfig();
$db -> config();
$db -> conn();

if($_GET['type']=="blog"){

    $query="SELECT * FROM blog WHERE id=".$_GET['id'];
    $db->queryDB($query);
    $row=$db->selectDB();

    $img=get_first_image($row['headimage']);
    $img=str_replace("&#34","",$img);
    $img=str_replace(";","",$img);

    $link=$img;
    $width=360;
    $height=200;
}
else if($_GET['type']=="car"){

    $query="SELECT * FROM cars WHERE id=".$_GET['id'];
    $db->queryDB($query);
    $row=$db->selectDB();
    $img=get_first_image(str_replace("&quot;","",str_replace("&#34;","",$row['slike'])));
    $img=str_replace("&#34","",$img);
    $img=str_replace(";","",$img);


    $link=$img;
    $width=390;
    $height=180;
}

else if($_GET['type']=="car-polovna"){

    $query="SELECT * FROM cars WHERE id=".$_GET['id'];
    $db->queryDB($query);
    $row=$db->selectDB();
    $img=get_first_image(str_replace("&quot;","",str_replace("&#34;","",$row['slike'])));
    $img=str_replace("&#34","",$img);
    $img=str_replace(";","",$img);


    $link=$img;
    $width=650;
    $height=450;
}
    $link=$site.$link;
$newThumb = CroppedThumbnail($link,$width,$height);

$ext = strtolower(pathinfo($link, PATHINFO_EXTENSION)); // Using strtolower to overcome case sensitive

$quality=(isset($_GET['quality']) ? $_GET['quality'] : 80);
if($link!="image-not-found.png"){
    imagejpeg($newThumb,"cache/".str_replace("/","_",$_SERVER[REQUEST_URI]),$quality);
}


// And display the image...
header('Cache-Control: max-age=31449600, public');
header('Content-type: image/webp');
imagewebp($newThumb,null,$quality);

}