document.addEventListener("DOMContentLoaded", function(){
    //mobile menu
    $("#openmobilenav").on('click', function(e){
        e.preventDefault();
        $("#mainnav").toggleClass('active');
    });
});
document.addEventListener('DOMContentLoaded', function() {
    const openModalButtons = document.querySelectorAll('.open-modal');
    const closeModalButtons = document.querySelectorAll('.close-modal');
    const modalOverlay = document.querySelector('.modal-overlay');

    openModalButtons.forEach(button => {
        button.addEventListener('click', function(event) {

            var clickedElement = event.target;
            if (clickedElement.hasAttribute('data-idcar')) {
                var idcarValue = clickedElement.getAttribute('data-idcar');
                $("#carlist").val(idcarValue);
            }

            const targetModal = this.getAttribute('data-target');
            const modal = document.querySelector(`.${targetModal}`);
            modalOverlay.classList.add('active');
            modal.style.display = 'block';
            document.body.classList.add('modal-open');
        });
    });

    closeModalButtons.forEach(button => {
        button.addEventListener('click', function() {
            const modal = this.closest('.modal');
            modal.style.display = 'none';
            modalOverlay.classList.remove('active');
            document.body.classList.remove('modal-open');
        });
    });

    // Close modal when clicking outside of it
    modalOverlay.addEventListener('click', function(event) {
        if (event.target === this) {
            closeModalButtons.forEach(button => {
                const modal = button.closest('.modal');
                modal.style.display = 'none';
                modalOverlay.classList.remove('active');
                document.body.classList.remove('modal-open');
            });
        }
    });


    // Funkcija za dinamičko učitavanje reCAPTCHA skripte
    function loadReCAPTCHAScript() {
        // Kreiranje novog <script> elementa
        var script = document.createElement('script');

        // Postavljanje atributa src sa URL-om reCAPTCHA skripte
        script.src = 'https://www.google.com/recaptcha/api.js?render=6LccJ60UAAAAAKElfmk8571BGWy4v0E9kN7kjDTK';

        // Dodavanje <script> elementa u <head> sekciju dokumenta
        document.head.appendChild(script);
    }

    $(".saveposition").on('focus',function (){
        loadReCAPTCHAScript();
    });

    $("#contactsubmit").on("click", function(e){
        e.preventDefault();
        let form = document.getElementById("contactform");
        var sveIspravno = true;

        // Iterirajte kroz sva polja forme
        var polja = form.querySelectorAll("[required]");
        for (var i = 0; i < polja.length; i++) {
            if (!polja[i].value) {
                sveIspravno = false;
            }
        }

        if (!sveIspravno) {
            alert("Molimo vas da popunite sva obavezna polja.");
        }
        else{
            //run google recaptcha
            grecaptcha.ready(function () {
                grecaptcha.execute('6LccJ60UAAAAAKElfmk8571BGWy4v0E9kN7kjDTK', { action: 'contact' }).then(function (token) {
                    var recaptchaResponse = document.getElementById('recaptchaResponse-contact');
                    recaptchaResponse.value = token;
                    form.submit();
                });
            });
        }
    });

    $("#rezervisidugme").on("click", function(e){
        e.preventDefault();
        grecaptcha.ready(function () {
            grecaptcha.execute('6LccJ60UAAAAAKElfmk8571BGWy4v0E9kN7kjDTK', { action: 'contact' }).then(function (token) {
                var recaptchaResponse = document.getElementById('recaptchaResponse-reservation');
                recaptchaResponse.value = token;

                var form = document.getElementById("bookingForm");
                var inputs = form.querySelectorAll("[required]");
                var isValid = true;

                for (var i = 0; i < inputs.length; i++) {
                    if (!inputs[i].value.trim()) {
                        isValid = false;
                        break;
                    }
                }

                if (!isValid) {
                    event.preventDefault(); // Zaustavlja slanje forme ako polja nisu validna
                    alert("Molimo vas popunite sva obavezna polja.");
                }
                else{
                    $("#bookingForm").submit();
                }
            });
        });
    });

});
