function obracunaj() {
    var dateRange = $('#daterangepicker').data('daterangepicker');
    var datumPreuzimanja = dateRange.startDate.toDate();
    var datumVracanja = dateRange.endDate.toDate();

    if (datumPreuzimanja === "" || datumVracanja === "") {
        $(".firstinfo").show();
    }
    else{
        $(".firstinfo").hide();
        var danas = new Date(); // Trenutni datum i vrijeme
        var juce = new Date(danas);
        juce.setDate(danas.getDate() - 1);

        if (datumPreuzimanja < juce) {
            $("#ukcena").html("<span style='color:red; font-weight:bold'>Datum preuzimanja mora biti veći od trenutnog datuma!</span>");
        }
        else if (datumVracanja <= datumPreuzimanja) {
            $("#ukcena").html("<span style='color:red; font-weight:bold'>Datum vraćanja mora biti veći od datuma preuzimanja!</span>");
        }
        else{
            //calculate
            let formData = $("#bookingForm").serialize();
            let brdana = Math.ceil((datumVracanja - datumPreuzimanja) / (1000 * 60 * 60 * 24));
            formData += '&brojDana=' + brdana;

            // AJAX poziv
            $.ajax({
                url: '/ajax/izracunaj.php', // Zamijenite putanjom vašeg server-side skripta za obracun
                type: 'POST',
                data: formData,
                success: function(response) {
                    console.log(response);
                    $('#ukcena').html(response);
                },
                error: function(xhr, status, error) {
                    console.error(error);
                }
            });
        }

    }
 

}

function handleChange() {
    obracunaj();
}

var elements = document.querySelectorAll('.calculate');
elements.forEach(function(element) {
    element.addEventListener('change', handleChange);
});